/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.GenericMods;
import org.immutables.fixture.modifiable.ModifiableGenericMods;
import org.immutables.fixture.modifiable.Supertype;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenericMods", generator="Immutables")
@Immutable
public final class ImmutableGenericMods<T>
implements GenericMods<T> {
    private final int a;
    private final T b;
    private final int c;

    private ImmutableGenericMods(int a, T b, int c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    public int a() {
        return this.a;
    }

    @Override
    public T b() {
        return this.b;
    }

    @Override
    public int c() {
        return this.c;
    }

    public final ImmutableGenericMods<T> withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableGenericMods<T>(value, this.b, this.c);
    }

    public final ImmutableGenericMods<T> withB(T value) {
        if (this.b == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "b");
        return new ImmutableGenericMods<T>(this.a, newValue, this.c);
    }

    public final ImmutableGenericMods<T> withC(int value) {
        if (this.c == value) {
            return this;
        }
        return new ImmutableGenericMods<T>(this.a, this.b, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGenericMods && this.equalTo(0, (ImmutableGenericMods)another);
    }

    private boolean equalTo(int synthetic, ImmutableGenericMods<?> another) {
        return this.a == another.a && this.b.equals(another.b) && this.c == another.c;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a;
        h += (h << 5) + this.b.hashCode();
        h += (h << 5) + this.c;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GenericMods").omitNullValues().add("a", this.a).add("b", this.b).add("c", this.c).toString();
    }

    public static <T> ImmutableGenericMods<T> copyOf(GenericMods<T> instance) {
        if (instance instanceof ImmutableGenericMods) {
            return (ImmutableGenericMods)instance;
        }
        return ImmutableGenericMods.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="GenericMods", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private static final long INIT_BIT_C = 4L;
        private long initBits = 7L;
        private int a;
        @Nullable
        private T b;
        private int c;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ModifiableGenericMods<T> instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance.aIsSet()) {
                this.a(instance.a());
            }
            if (instance.bIsSet()) {
                this.b(instance.b());
            }
            if (instance.cIsSet()) {
                this.c(instance.c());
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(Supertype instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(GenericMods<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Supertype instance;
            if (object instanceof ModifiableGenericMods) {
                this.from((ModifiableGenericMods)object);
                return;
            }
            long bits = 0L;
            if (object instanceof Supertype) {
                instance = (Supertype)object;
                if ((bits & 1L) == 0L) {
                    this.a(instance.a());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.c(instance.c());
                    bits |= 2L;
                }
            }
            if (object instanceof GenericMods) {
                instance = (GenericMods)object;
                if ((bits & 1L) == 0L) {
                    this.a(instance.a());
                    bits |= 1L;
                }
                this.b(instance.b());
                if ((bits & 2L) == 0L) {
                    this.c(instance.c());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> b(T b) {
            this.b = Objects.requireNonNull(b, "b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> c(int c) {
            this.c = c;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGenericMods<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGenericMods(this.a, this.b, this.c);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("c");
            }
            return "Cannot build GenericMods, some of required attributes are not set " + attributes;
        }
    }
}

