/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.collect.BiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import io.atlassian.fugue.Option;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.immutables.fixture.modifiable.Unit;
import org.immutables.value.Value;

@Value.Immutable
@Value.Modifiable
public interface Companion {
    public int integer();

    public String string();

    @Nullable
    public Boolean bools();

    public List<String> str();

    public Set<Integer> ints();

    public int[] arrayInts();

    public String[] arrayStrings();

    @Value.NaturalOrder
    public SortedSet<Integer> ords();

    public Set<RetentionPolicy> pols();

    @Value.ReverseOrder
    public NavigableSet<Integer> navs();

    public Map<Long, Integer> just();

    @Value.NaturalOrder
    public SortedMap<Integer, String> ordsmap();

    public Map<RetentionPolicy, Integer> polsmap();

    @Value.ReverseOrder
    public NavigableMap<String, Integer> navsmap();

    @Value.Style(deferCollectionAllocation=true)
    @Value.Modifiable
    @Value.Immutable
    public static interface NullableAndDefault {
        public List<String> lst();

        @Nullable
        @Value.Default
        default public List<String> str() {
            return null;
        }

        @Value.Default
        default public Set<Integer> ints() {
            return Collections.singleton(1);
        }

        @Value.Default
        default public int[] arrayInts() {
            return new int[0];
        }

        @Nullable
        @Value.NaturalOrder
        @Value.Default
        default public SortedSet<Integer> ords() {
            return null;
        }

        @Value.Default
        default public Set<RetentionPolicy> pols() {
            return EnumSet.noneOf(RetentionPolicy.class);
        }

        @Value.Default
        @Value.ReverseOrder
        default public NavigableSet<Integer> navs() {
            return Collections.emptyNavigableSet();
        }
    }

    @Value.Modifiable
    @Value.Immutable
    @Value.Style(jdkOnly=true)
    public static interface JdkComp {
        public int integer();

        public String string();

        @Nullable
        public Boolean bools();

        public List<String> str();

        public Set<Integer> ints();

        public int[] arrayInts();

        public String[] arrayStrings();

        @Value.NaturalOrder
        public SortedSet<Integer> ords();

        public Set<RetentionPolicy> pols();

        @Value.ReverseOrder
        public NavigableSet<Integer> navs();
    }

    @Value.Style(strictBuilder=true)
    @Value.Modifiable
    public static interface Extra {
        @Value.Parameter
        public Multiset<String> bag();

        @Value.Parameter
        public Multimap<Integer, String> index();

        @Value.Parameter
        public ListMultimap<Integer, String> indexList();

        @Value.Parameter
        public SetMultimap<Integer, String> indexSet();

        @Value.Parameter
        public BiMap<Integer, String> biMap();
    }

    @Value.Modifiable
    public static interface Standalone {
        @Value.Parameter
        public int first();

        @Value.Parameter
        public String second();

        @Value.Parameter
        public short sh();

        @Value.Parameter
        public char ch();

        @Value.Parameter
        public boolean bool();

        @Value.Parameter
        public double dob();

        @Value.Parameter
        public float fl();

        public com.google.common.base.Optional<Integer> v1();

        public Optional<Integer> v2();

        public OptionalInt i1();

        public OptionalLong l1();

        public OptionalDouble d1();

        public Option<Integer> fugue3();

        @Value.Default
        default public int def() {
            return 1;
        }

        @Value.Default
        default public String defs() {
            return "";
        }

        @Value.Lazy
        default public String lazy() {
            return "";
        }

        @Value.Derived
        default public int derived() {
            return (Integer)this.v1().or((Object)0);
        }

        @Nullable
        public List<Unit> nullableUnit();
    }

    @Value.Modifiable
    @Value.Style(create="new")
    public static interface Small {
        @Value.Parameter
        public int first();

        @Value.Parameter
        public String second();
    }
}

