/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.JdkUtil;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JdkUtil", generator="Immutables")
@Immutable
public final class ImmutableJdkUtil
implements JdkUtil {
    private final boolean a;
    private final double d;
    private final float f;
    private final long l;
    private final char c;
    private final Object o;

    private ImmutableJdkUtil(boolean a, double d, float f, long l, char c, Object o) {
        this.a = a;
        this.d = d;
        this.f = f;
        this.l = l;
        this.c = c;
        this.o = o;
    }

    @Override
    public boolean a() {
        return this.a;
    }

    @Override
    public double d() {
        return this.d;
    }

    @Override
    public float f() {
        return this.f;
    }

    @Override
    public long l() {
        return this.l;
    }

    @Override
    public char c() {
        return this.c;
    }

    @Override
    public Object o() {
        return this.o;
    }

    public final ImmutableJdkUtil withA(boolean value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableJdkUtil(value, this.d, this.f, this.l, this.c, this.o);
    }

    public final ImmutableJdkUtil withD(double value) {
        if (Double.doubleToLongBits(this.d) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableJdkUtil(this.a, value, this.f, this.l, this.c, this.o);
    }

    public final ImmutableJdkUtil withF(float value) {
        if (Float.floatToIntBits(this.f) == Float.floatToIntBits(value)) {
            return this;
        }
        return new ImmutableJdkUtil(this.a, this.d, value, this.l, this.c, this.o);
    }

    public final ImmutableJdkUtil withL(long value) {
        if (this.l == value) {
            return this;
        }
        return new ImmutableJdkUtil(this.a, this.d, this.f, value, this.c, this.o);
    }

    public final ImmutableJdkUtil withC(char value) {
        if (this.c == value) {
            return this;
        }
        return new ImmutableJdkUtil(this.a, this.d, this.f, this.l, value, this.o);
    }

    public final ImmutableJdkUtil withO(Object value) {
        if (this.o == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "o");
        return new ImmutableJdkUtil(this.a, this.d, this.f, this.l, this.c, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJdkUtil && this.equalTo(0, (ImmutableJdkUtil)another);
    }

    private boolean equalTo(int synthetic, ImmutableJdkUtil another) {
        return this.a == another.a && Double.doubleToLongBits(this.d) == Double.doubleToLongBits(another.d) && Float.floatToIntBits(this.f) == Float.floatToIntBits(another.f) && this.l == another.l && this.c == another.c && this.o.equals(another.o);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.a);
        h += (h << 5) + Double.hashCode(this.d);
        h += (h << 5) + Float.hashCode(this.f);
        h += (h << 5) + Long.hashCode(this.l);
        h += (h << 5) + Character.hashCode(this.c);
        h += (h << 5) + this.o.hashCode();
        return h;
    }

    public String toString() {
        return "JdkUtil{a=" + this.a + ", d=" + this.d + ", f=" + this.f + ", l=" + this.l + ", c=" + this.c + ", o=" + this.o + "}";
    }

    public static ImmutableJdkUtil copyOf(JdkUtil instance) {
        if (instance instanceof ImmutableJdkUtil) {
            return (ImmutableJdkUtil)instance;
        }
        return ImmutableJdkUtil.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JdkUtil", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_D = 2L;
        private static final long INIT_BIT_F = 4L;
        private static final long INIT_BIT_L = 8L;
        private static final long INIT_BIT_C = 16L;
        private static final long INIT_BIT_O = 32L;
        private long initBits = 63L;
        private boolean a;
        private double d;
        private float f;
        private long l;
        private char c;
        @Nullable
        private Object o;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JdkUtil instance) {
            Objects.requireNonNull(instance, "instance");
            this.a(instance.a());
            this.d(instance.d());
            this.f(instance.f());
            this.l(instance.l());
            this.c(instance.c());
            this.o(instance.o());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder a(boolean a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder d(double d) {
            this.d = d;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder f(float f) {
            this.f = f;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder l(long l) {
            this.l = l;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder c(char c) {
            this.c = c;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder o(Object o) {
            this.o = Objects.requireNonNull(o, "o");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableJdkUtil build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJdkUtil(this.a, this.d, this.f, this.l, this.c, this.o);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("d");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("f");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("l");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("c");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("o");
            }
            return "Cannot build JdkUtil, some of required attributes are not set " + attributes;
        }
    }
}

