/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.JdkOptionalsSer;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JdkOptionalsSer", generator="Immutables")
@Immutable
final class ImmutableJdkOptionalsSer
implements JdkOptionalsSer {
    @Nullable
    private final String v2;
    @Nullable
    private final Integer i1;
    @Nullable
    private final Long l1;
    @Nullable
    private final Double d1;

    private ImmutableJdkOptionalsSer() {
        this.v2 = null;
        this.i1 = null;
        this.l1 = null;
        this.d1 = null;
    }

    private ImmutableJdkOptionalsSer(Optional<String> v2, OptionalInt i1, OptionalLong l1, OptionalDouble d1) {
        this.v2 = v2.orElse(null);
        this.i1 = i1.isPresent() ? Integer.valueOf(i1.getAsInt()) : null;
        this.l1 = l1.isPresent() ? Long.valueOf(l1.getAsLong()) : null;
        this.d1 = d1.isPresent() ? Double.valueOf(d1.getAsDouble()) : null;
    }

    private ImmutableJdkOptionalsSer(ImmutableJdkOptionalsSer original, @Nullable String v2, @Nullable Integer i1, @Nullable Long l1, @Nullable Double d1) {
        this.v2 = v2;
        this.i1 = i1;
        this.l1 = l1;
        this.d1 = d1;
    }

    @Override
    public Optional<String> v2() {
        return Optional.ofNullable(this.v2);
    }

    @Override
    public OptionalInt i1() {
        return this.i1 != null ? OptionalInt.of(this.i1) : OptionalInt.empty();
    }

    @Override
    public OptionalLong l1() {
        return this.l1 != null ? OptionalLong.of(this.l1) : OptionalLong.empty();
    }

    @Override
    public OptionalDouble d1() {
        return this.d1 != null ? OptionalDouble.of(this.d1) : OptionalDouble.empty();
    }

    public final ImmutableJdkOptionalsSer withV2(String value) {
        String newValue = Objects.requireNonNull(value, "v2");
        if (Objects.equals(this.v2, newValue)) {
            return this;
        }
        return new ImmutableJdkOptionalsSer(this, newValue, this.i1, this.l1, this.d1);
    }

    public final ImmutableJdkOptionalsSer withV2(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.v2, value)) {
            return this;
        }
        return new ImmutableJdkOptionalsSer(this, value, this.i1, this.l1, this.d1);
    }

    public final ImmutableJdkOptionalsSer withI1(int value) {
        Integer newValue = value;
        if (Objects.equals(this.i1, newValue)) {
            return this;
        }
        return new ImmutableJdkOptionalsSer(this, this.v2, newValue, this.l1, this.d1);
    }

    public final ImmutableJdkOptionalsSer withI1(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.i1, value)) {
            return this;
        }
        return new ImmutableJdkOptionalsSer(this, this.v2, value, this.l1, this.d1);
    }

    public final ImmutableJdkOptionalsSer withL1(long value) {
        Long newValue = value;
        if (Objects.equals(this.l1, newValue)) {
            return this;
        }
        return new ImmutableJdkOptionalsSer(this, this.v2, this.i1, newValue, this.d1);
    }

    public final ImmutableJdkOptionalsSer withL1(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.l1, value)) {
            return this;
        }
        return new ImmutableJdkOptionalsSer(this, this.v2, this.i1, value, this.d1);
    }

    public final ImmutableJdkOptionalsSer withD1(double value) {
        Double newValue = value;
        if (Objects.equals(this.d1, newValue)) {
            return this;
        }
        return new ImmutableJdkOptionalsSer(this, this.v2, this.i1, this.l1, newValue);
    }

    public final ImmutableJdkOptionalsSer withD1(OptionalDouble optional) {
        Double value;
        Double d = value = optional.isPresent() ? Double.valueOf(optional.getAsDouble()) : null;
        if (Objects.equals(this.d1, value)) {
            return this;
        }
        return new ImmutableJdkOptionalsSer(this, this.v2, this.i1, this.l1, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJdkOptionalsSer && this.equalTo(0, (ImmutableJdkOptionalsSer)another);
    }

    private boolean equalTo(int synthetic, ImmutableJdkOptionalsSer another) {
        return Objects.equals(this.v2, another.v2) && Objects.equals(this.i1, another.i1) && Objects.equals(this.l1, another.l1) && Objects.equals(this.d1, another.d1);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.v2);
        h += (h << 5) + Objects.hashCode(this.i1);
        h += (h << 5) + Objects.hashCode(this.l1);
        h += (h << 5) + Objects.hashCode(this.d1);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JdkOptionalsSer").omitNullValues().add("v2", (Object)this.v2).add("i1", (Object)this.i1).add("l1", (Object)this.l1).add("d1", (Object)this.d1).toString();
    }

    public static ImmutableJdkOptionalsSer of(Optional<String> v2, OptionalInt i1, OptionalLong l1, OptionalDouble d1) {
        return new ImmutableJdkOptionalsSer(v2, i1, l1, d1);
    }

    public static ImmutableJdkOptionalsSer copyOf(JdkOptionalsSer instance) {
        if (instance instanceof ImmutableJdkOptionalsSer) {
            return (ImmutableJdkOptionalsSer)instance;
        }
        return ImmutableJdkOptionalsSer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JdkOptionalsSer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String v2;
        @Nullable
        private Integer i1;
        @Nullable
        private Long l1;
        @Nullable
        private Double d1;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JdkOptionalsSer instance) {
            OptionalDouble d1Optional;
            OptionalLong l1Optional;
            OptionalInt i1Optional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> v2Optional = instance.v2();
            if (v2Optional.isPresent()) {
                this.v2(v2Optional);
            }
            if ((i1Optional = instance.i1()).isPresent()) {
                this.i1(i1Optional);
            }
            if ((l1Optional = instance.l1()).isPresent()) {
                this.l1(l1Optional);
            }
            if ((d1Optional = instance.d1()).isPresent()) {
                this.d1(d1Optional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder v2(String v2) {
            this.v2 = Objects.requireNonNull(v2, "v2");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder v2(Optional<String> v2) {
            this.v2 = v2.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder i1(int i1) {
            this.i1 = i1;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder i1(OptionalInt i1) {
            this.i1 = i1.isPresent() ? Integer.valueOf(i1.getAsInt()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder l1(long l1) {
            this.l1 = l1;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder l1(OptionalLong l1) {
            this.l1 = l1.isPresent() ? Long.valueOf(l1.getAsLong()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder d1(double d1) {
            this.d1 = d1;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder d1(OptionalDouble d1) {
            this.d1 = d1.isPresent() ? Double.valueOf(d1.getAsDouble()) : null;
            return this;
        }

        public ImmutableJdkOptionalsSer build() {
            return new ImmutableJdkOptionalsSer(null, this.v2, this.i1, this.l1, this.d1);
        }
    }
}

