/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.EmptyEnumMapAndSet;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EmptyEnumMapAndSet", generator="Immutables")
@Immutable
public final class ImmutableEmptyEnumMapAndSet
extends EmptyEnumMapAndSet {
    private final Map<EmptyEnumMapAndSet.Generations, String> genNames;
    private final Set<EmptyEnumMapAndSet.Generations> gens;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEmptyEnumMapAndSet(Builder builder) {
        if (builder.genNamesIsSet()) {
            this.initShim.genNames(ImmutableEmptyEnumMapAndSet.createUnmodifiableEnumMap(false, false, builder.genNames));
        }
        if (builder.gensIsSet()) {
            this.initShim.gens(ImmutableEmptyEnumMapAndSet.createUnmodifiableEnumSet(builder.gens));
        }
        this.genNames = this.initShim.genNames();
        this.gens = this.initShim.gens();
        this.initShim = null;
    }

    private ImmutableEmptyEnumMapAndSet(Map<EmptyEnumMapAndSet.Generations, String> genNames, Set<EmptyEnumMapAndSet.Generations> gens) {
        this.genNames = genNames;
        this.gens = gens;
        this.initShim = null;
    }

    @Override
    public Map<EmptyEnumMapAndSet.Generations, String> genNames() {
        InitShim shim = this.initShim;
        return shim != null ? shim.genNames() : this.genNames;
    }

    @Override
    public Set<EmptyEnumMapAndSet.Generations> gens() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gens() : this.gens;
    }

    public final ImmutableEmptyEnumMapAndSet withGenNames(Map<EmptyEnumMapAndSet.Generations, ? extends String> entries) {
        if (this.genNames == entries) {
            return this;
        }
        Map<EmptyEnumMapAndSet.Generations, String> newValue = ImmutableEmptyEnumMapAndSet.createUnmodifiableEnumMap(true, false, entries);
        return new ImmutableEmptyEnumMapAndSet(newValue, this.gens);
    }

    public final ImmutableEmptyEnumMapAndSet withGens(EmptyEnumMapAndSet.Generations ... elements) {
        Set<EmptyEnumMapAndSet.Generations> newValue = ImmutableEmptyEnumMapAndSet.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableEmptyEnumMapAndSet(this.genNames, newValue);
    }

    public final ImmutableEmptyEnumMapAndSet withGens(Iterable<EmptyEnumMapAndSet.Generations> elements) {
        if (this.gens == elements) {
            return this;
        }
        Set<EmptyEnumMapAndSet.Generations> newValue = ImmutableEmptyEnumMapAndSet.createUnmodifiableEnumSet(elements);
        return new ImmutableEmptyEnumMapAndSet(this.genNames, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmptyEnumMapAndSet && this.equalTo(0, (ImmutableEmptyEnumMapAndSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableEmptyEnumMapAndSet another) {
        return this.genNames.equals(another.genNames) && this.gens.equals(another.gens);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.genNames.hashCode();
        h += (h << 5) + this.gens.hashCode();
        return h;
    }

    public String toString() {
        return "EmptyEnumMapAndSet{genNames=" + this.genNames + ", gens=" + this.gens + "}";
    }

    public static ImmutableEmptyEnumMapAndSet copyOf(EmptyEnumMapAndSet instance) {
        if (instance instanceof ImmutableEmptyEnumMapAndSet) {
            return (ImmutableEmptyEnumMapAndSet)instance;
        }
        return ImmutableEmptyEnumMapAndSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ImmutableEmptyEnumMapAndSet.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<K, ? extends V> enumMap = new EnumMap<K, V>(map);
        if (checkNulls || skipNulls) {
            Iterator<V> it = map.values().iterator();
            while (it.hasNext()) {
                V v = it.next();
                if (checkNulls) {
                    Objects.requireNonNull(v, "value");
                    continue;
                }
                if (!skipNulls || v != null) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableMap(enumMap);
    }

    @Generated(from="EmptyEnumMapAndSet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_GEN_NAMES = 1L;
        private static final long OPT_BIT_GENS = 2L;
        private long optBits;
        private EnumMap<EmptyEnumMapAndSet.Generations, String> genNames = new EnumMap(EmptyEnumMapAndSet.Generations.class);
        private EnumSet<EmptyEnumMapAndSet.Generations> gens = EnumSet.noneOf(EmptyEnumMapAndSet.Generations.class);

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EmptyEnumMapAndSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllGenNames(instance.genNames());
            this.addAllGens(instance.gens());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putGenNames(EmptyEnumMapAndSet.Generations key, String value) {
            this.genNames.put((EmptyEnumMapAndSet.Generations)((Enum)Objects.requireNonNull(key, "genNames key")), value == null ? Objects.requireNonNull(value, "genNames value for key: " + (Object)((Object)key)) : value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putGenNames(Map.Entry<EmptyEnumMapAndSet.Generations, ? extends String> entry) {
            EmptyEnumMapAndSet.Generations k = entry.getKey();
            String v = entry.getValue();
            this.genNames.put((EmptyEnumMapAndSet.Generations)((Enum)Objects.requireNonNull(k, "genNames key")), v == null ? Objects.requireNonNull(v, "genNames value for key: " + (Object)((Object)k)) : v);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder genNames(Map<EmptyEnumMapAndSet.Generations, ? extends String> entries) {
            this.genNames.clear();
            this.optBits |= 1L;
            return this.putAllGenNames(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllGenNames(Map<EmptyEnumMapAndSet.Generations, ? extends String> entries) {
            for (Map.Entry<EmptyEnumMapAndSet.Generations, ? extends String> e : entries.entrySet()) {
                EmptyEnumMapAndSet.Generations k = e.getKey();
                String v = e.getValue();
                this.genNames.put((EmptyEnumMapAndSet.Generations)((Enum)Objects.requireNonNull(k, "genNames key")), v == null ? Objects.requireNonNull(v, "genNames value for key: " + (Object)((Object)k)) : v);
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGens(EmptyEnumMapAndSet.Generations element) {
            this.gens.add(Objects.requireNonNull(element, "gens element"));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGens(EmptyEnumMapAndSet.Generations ... elements) {
            for (EmptyEnumMapAndSet.Generations element : elements) {
                this.gens.add(Objects.requireNonNull(element, "gens element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gens(Iterable<EmptyEnumMapAndSet.Generations> elements) {
            this.gens.clear();
            return this.addAllGens(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGens(Iterable<EmptyEnumMapAndSet.Generations> elements) {
            for (EmptyEnumMapAndSet.Generations element : elements) {
                this.gens.add(Objects.requireNonNull(element, "gens element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public ImmutableEmptyEnumMapAndSet build() {
            return new ImmutableEmptyEnumMapAndSet(this);
        }

        private boolean genNamesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean gensIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="EmptyEnumMapAndSet", generator="Immutables")
    private final class InitShim {
        private byte genNamesBuildStage = 0;
        private Map<EmptyEnumMapAndSet.Generations, String> genNames;
        private byte gensBuildStage = 0;
        private Set<EmptyEnumMapAndSet.Generations> gens;

        private InitShim() {
        }

        Map<EmptyEnumMapAndSet.Generations, String> genNames() {
            if (this.genNamesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.genNamesBuildStage == 0) {
                this.genNamesBuildStage = (byte)-1;
                this.genNames = ImmutableEmptyEnumMapAndSet.createUnmodifiableEnumMap(true, false, ImmutableEmptyEnumMapAndSet.super.genNames());
                this.genNamesBuildStage = 1;
            }
            return this.genNames;
        }

        void genNames(Map<EmptyEnumMapAndSet.Generations, String> genNames) {
            this.genNames = genNames;
            this.genNamesBuildStage = 1;
        }

        Set<EmptyEnumMapAndSet.Generations> gens() {
            if (this.gensBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gensBuildStage == 0) {
                this.gensBuildStage = (byte)-1;
                this.gens = ImmutableEmptyEnumMapAndSet.createUnmodifiableEnumSet(ImmutableEmptyEnumMapAndSet.super.gens());
                this.gensBuildStage = 1;
            }
            return this.gens;
        }

        void gens(Set<EmptyEnumMapAndSet.Generations> gens) {
            this.gens = gens;
            this.gensBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.genNamesBuildStage == -1) {
                attributes.add("genNames");
            }
            if (this.gensBuildStage == -1) {
                attributes.add("gens");
            }
            return "Cannot build EmptyEnumMapAndSet, attribute initializers form cycle " + attributes;
        }
    }
}

