/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.BlogEvent;
import org.immutables.fixture.jackson.BodyChanged;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BlogEvent.AbstractPostAdded", generator="Immutables")
@Immutable
public final class PostAdded
implements BlogEvent.AbstractPostAdded {
    private final String postId;
    private final BodyChanged content;

    private PostAdded(String postId, BodyChanged content) {
        this.postId = postId;
        this.content = content;
    }

    @Override
    @JsonProperty(value="postId")
    public String getPostId() {
        return this.postId;
    }

    @Override
    @JsonProperty(value="content")
    public BodyChanged getContent() {
        return this.content;
    }

    public final PostAdded withPostId(String value) {
        String newValue = Objects.requireNonNull(value, "postId");
        if (this.postId.equals(newValue)) {
            return this;
        }
        return new PostAdded(newValue, this.content);
    }

    public final PostAdded withContent(BodyChanged value) {
        if (this.content == value) {
            return this;
        }
        BodyChanged newValue = Objects.requireNonNull(value, "content");
        return new PostAdded(this.postId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PostAdded && this.equalTo(0, (PostAdded)another);
    }

    private boolean equalTo(int synthetic, PostAdded another) {
        return this.postId.equals(another.postId) && this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.postId.hashCode();
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PostAdded").omitNullValues().add("postId", (Object)this.postId).add("content", (Object)this.content).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static PostAdded fromJson(Json json) {
        Builder builder = PostAdded.builder();
        if (json.postId != null) {
            builder.postId(json.postId);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        return builder.build();
    }

    public static PostAdded copyOf(BlogEvent.AbstractPostAdded instance) {
        if (instance instanceof PostAdded) {
            return (PostAdded)instance;
        }
        return PostAdded.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BlogEvent.AbstractPostAdded", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_POST_ID = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private long initBits = 3L;
        @Nullable
        private String postId;
        @Nullable
        private BodyChanged content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BlogEvent.AbstractPostAdded instance) {
            Objects.requireNonNull(instance, "instance");
            this.postId(instance.getPostId());
            this.content(instance.getContent());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder postId(String postId) {
            this.postId = Objects.requireNonNull(postId, "postId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder content(BodyChanged content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public PostAdded build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PostAdded(this.postId, this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("postId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build PostAdded, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BlogEvent.AbstractPostAdded", generator="Immutables")
    static final class Json
    implements BlogEvent.AbstractPostAdded {
        @Nullable
        String postId;
        @Nullable
        BodyChanged content;

        Json() {
        }

        @JsonProperty(value="postId")
        public void setPostId(String postId) {
            this.postId = postId;
        }

        @JsonProperty(value="content")
        public void setContent(BodyChanged content) {
            this.content = content;
        }

        @Override
        public String getPostId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BodyChanged getContent() {
            throw new UnsupportedOperationException();
        }
    }
}

