/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.StagedEntity;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StagedEntity", generator="Immutables")
@Immutable
public final class ImmutableStagedEntity
implements StagedEntity {
    private final String required;
    private final String optional;
    private final boolean optionalPrimitive;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStagedEntity(Builder builder) {
        this.required = builder.required;
        if (builder.optionalIsSet()) {
            this.initShim.optional(builder.optional);
        }
        if (builder.optionalPrimitiveIsSet()) {
            this.initShim.optionalPrimitive(builder.optionalPrimitive);
        }
        this.optional = this.initShim.getOptional();
        this.optionalPrimitive = this.initShim.getOptionalPrimitive();
        this.initShim = null;
    }

    private ImmutableStagedEntity(String required, String optional, boolean optionalPrimitive) {
        this.required = required;
        this.optional = optional;
        this.optionalPrimitive = optionalPrimitive;
        this.initShim = null;
    }

    private String getOptionalInitialize() {
        return StagedEntity.super.getOptional();
    }

    private boolean getOptionalPrimitiveInitialize() {
        return StagedEntity.super.getOptionalPrimitive();
    }

    @Override
    @JsonProperty(value="required")
    public String getRequired() {
        return this.required;
    }

    @Override
    @JsonProperty(value="optional")
    public String getOptional() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOptional() : this.optional;
    }

    @Override
    @JsonProperty(value="optionalPrimitive")
    public boolean getOptionalPrimitive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOptionalPrimitive() : this.optionalPrimitive;
    }

    public final ImmutableStagedEntity withRequired(String value) {
        String newValue = Objects.requireNonNull(value, "required");
        if (this.required.equals(newValue)) {
            return this;
        }
        return new ImmutableStagedEntity(newValue, this.optional, this.optionalPrimitive);
    }

    public final ImmutableStagedEntity withOptional(String value) {
        String newValue = Objects.requireNonNull(value, "optional");
        if (this.optional.equals(newValue)) {
            return this;
        }
        return new ImmutableStagedEntity(this.required, newValue, this.optionalPrimitive);
    }

    public final ImmutableStagedEntity withOptionalPrimitive(boolean value) {
        if (this.optionalPrimitive == value) {
            return this;
        }
        return new ImmutableStagedEntity(this.required, this.optional, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStagedEntity && this.equalTo(0, (ImmutableStagedEntity)another);
    }

    private boolean equalTo(int synthetic, ImmutableStagedEntity another) {
        return this.required.equals(another.required) && this.optional.equals(another.optional) && this.optionalPrimitive == another.optionalPrimitive;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.required.hashCode();
        h += (h << 5) + this.optional.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.optionalPrimitive);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StagedEntity").omitNullValues().add("required", (Object)this.required).add("optional", (Object)this.optional).add("optionalPrimitive", this.optionalPrimitive).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStagedEntity fromJson(Json json) {
        Builder builder = (Builder)ImmutableStagedEntity.builder();
        if (json.required != null) {
            builder.required(json.required);
        }
        if (json.optionalIsSet) {
            builder.optional(json.optional);
        }
        if (json.optionalPrimitiveIsSet) {
            builder.optionalPrimitive(json.optionalPrimitive);
        }
        return builder.build();
    }

    public static ImmutableStagedEntity copyOf(StagedEntity instance) {
        if (instance instanceof ImmutableStagedEntity) {
            return (ImmutableStagedEntity)instance;
        }
        return ((Builder)ImmutableStagedEntity.builder()).required(instance.getRequired()).optional(instance.getOptional()).optionalPrimitive(instance.getOptionalPrimitive()).build();
    }

    public static RequiredBuildStage builder() {
        return new Builder();
    }

    @Generated(from="StagedEntity", generator="Immutables")
    public static interface BuildFinal {
        public BuildFinal optional(String var1);

        public BuildFinal optionalPrimitive(boolean var1);

        public ImmutableStagedEntity build();
    }

    @Generated(from="StagedEntity", generator="Immutables")
    public static interface RequiredBuildStage {
        public BuildFinal required(String var1);
    }

    @Generated(from="StagedEntity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements RequiredBuildStage,
    BuildFinal {
        private static final long INIT_BIT_REQUIRED = 1L;
        private static final long OPT_BIT_OPTIONAL = 1L;
        private static final long OPT_BIT_OPTIONAL_PRIMITIVE = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String required;
        @Nullable
        private String optional;
        private boolean optionalPrimitive;

        private Builder() {
        }

        @Override
        @JsonProperty(value="required")
        @CanIgnoreReturnValue
        public final Builder required(String required) {
            Builder.checkNotIsSet(this.requiredIsSet(), "required");
            this.required = Objects.requireNonNull(required, "required");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="optional")
        @CanIgnoreReturnValue
        public final Builder optional(String optional) {
            Builder.checkNotIsSet(this.optionalIsSet(), "optional");
            this.optional = Objects.requireNonNull(optional, "optional");
            this.optBits |= 1L;
            return this;
        }

        @Override
        @JsonProperty(value="optionalPrimitive")
        @CanIgnoreReturnValue
        public final Builder optionalPrimitive(boolean optionalPrimitive) {
            Builder.checkNotIsSet(this.optionalPrimitiveIsSet(), "optionalPrimitive");
            this.optionalPrimitive = optionalPrimitive;
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutableStagedEntity build() {
            this.checkRequiredAttributes();
            return new ImmutableStagedEntity(this);
        }

        private boolean optionalIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean optionalPrimitiveIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean requiredIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of StagedEntity is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.requiredIsSet()) {
                attributes.add("required");
            }
            return "Cannot build StagedEntity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StagedEntity", generator="Immutables")
    static final class Json
    implements StagedEntity {
        @Nullable
        String required;
        @Nullable
        String optional;
        boolean optionalIsSet;
        boolean optionalPrimitive;
        boolean optionalPrimitiveIsSet;

        Json() {
        }

        @JsonProperty(value="required")
        public void setRequired(String required) {
            this.required = required;
        }

        @JsonProperty(value="optional")
        public void setOptional(String optional) {
            this.optional = optional;
            this.optionalIsSet = null != optional;
        }

        @JsonProperty(value="optionalPrimitive")
        public void setOptionalPrimitive(boolean optionalPrimitive) {
            this.optionalPrimitive = optionalPrimitive;
            this.optionalPrimitiveIsSet = true;
        }

        @Override
        public String getRequired() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOptional() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getOptionalPrimitive() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="StagedEntity", generator="Immutables")
    private final class InitShim {
        private byte optionalBuildStage = 0;
        private String optional;
        private byte optionalPrimitiveBuildStage = 0;
        private boolean optionalPrimitive;

        private InitShim() {
        }

        String getOptional() {
            if (this.optionalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionalBuildStage == 0) {
                this.optionalBuildStage = (byte)-1;
                this.optional = Objects.requireNonNull(ImmutableStagedEntity.this.getOptionalInitialize(), "optional");
                this.optionalBuildStage = 1;
            }
            return this.optional;
        }

        void optional(String optional) {
            this.optional = optional;
            this.optionalBuildStage = 1;
        }

        boolean getOptionalPrimitive() {
            if (this.optionalPrimitiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionalPrimitiveBuildStage == 0) {
                this.optionalPrimitiveBuildStage = (byte)-1;
                this.optionalPrimitive = ImmutableStagedEntity.this.getOptionalPrimitiveInitialize();
                this.optionalPrimitiveBuildStage = 1;
            }
            return this.optionalPrimitive;
        }

        void optionalPrimitive(boolean optionalPrimitive) {
            this.optionalPrimitive = optionalPrimitive;
            this.optionalPrimitiveBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.optionalBuildStage == -1) {
                attributes.add("optional");
            }
            if (this.optionalPrimitiveBuildStage == -1) {
                attributes.add("optionalPrimitive");
            }
            return "Cannot build StagedEntity, attribute initializers form cycle " + attributes;
        }
    }
}

