/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.ProjectInformation;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProjectInformation", generator="Immutables")
@Immutable
public final class ImmutableProjectInformation
implements ProjectInformation {
    private final Integer organizationId;

    private ImmutableProjectInformation(Integer organizationId) {
        this.organizationId = organizationId;
    }

    @Override
    @JsonProperty
    public Integer getOrganizationId() {
        return this.organizationId;
    }

    public final ImmutableProjectInformation withOrganizationId(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "organizationId");
        if (this.organizationId.equals(newValue)) {
            return this;
        }
        return new ImmutableProjectInformation(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProjectInformation && this.equalTo(0, (ImmutableProjectInformation)another);
    }

    private boolean equalTo(int synthetic, ImmutableProjectInformation another) {
        return this.organizationId.equals(another.organizationId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.organizationId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProjectInformation").omitNullValues().add("organizationId", (Object)this.organizationId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProjectInformation fromJson(Json json) {
        Builder builder = ImmutableProjectInformation.builder();
        if (json.organizationId != null) {
            builder.organizationId(json.organizationId);
        }
        return builder.build();
    }

    public static ImmutableProjectInformation copyOf(ProjectInformation instance) {
        if (instance instanceof ImmutableProjectInformation) {
            return (ImmutableProjectInformation)instance;
        }
        return ImmutableProjectInformation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProjectInformation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private Integer organizationId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ProjectInformation instance) {
            Objects.requireNonNull(instance, "instance");
            this.organizationId(instance.getOrganizationId());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder organizationId(Integer organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableProjectInformation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProjectInformation(this.organizationId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build ProjectInformation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ProjectInformation", generator="Immutables")
    static final class Json
    implements ProjectInformation {
        @Nullable
        Integer organizationId;

        Json() {
        }

        @JsonProperty
        public void setOrganizationId(Integer organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public Integer getOrganizationId() {
            throw new UnsupportedOperationException();
        }
    }
}

