/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.KeywordNames;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeywordNames", generator="Immutables")
@Immutable
public final class ImmutableKeywordNames
implements KeywordNames {
    private final long getLong;
    private final boolean isDefault;

    private ImmutableKeywordNames(long getLong, boolean isDefault) {
        this.getLong = getLong;
        this.isDefault = isDefault;
    }

    @Override
    @JsonProperty
    public long getLong() {
        return this.getLong;
    }

    @Override
    @JsonProperty
    public boolean isDefault() {
        return this.isDefault;
    }

    public final ImmutableKeywordNames withLong(long value) {
        if (this.getLong == value) {
            return this;
        }
        return new ImmutableKeywordNames(value, this.isDefault);
    }

    public final ImmutableKeywordNames withDefault(boolean value) {
        if (this.isDefault == value) {
            return this;
        }
        return new ImmutableKeywordNames(this.getLong, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeywordNames && this.equalTo(0, (ImmutableKeywordNames)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeywordNames another) {
        return this.getLong == another.getLong && this.isDefault == another.isDefault;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.getLong);
        h += (h << 5) + Booleans.hashCode((boolean)this.isDefault);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeywordNames").omitNullValues().add("long", this.getLong).add("default", this.isDefault).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableKeywordNames fromJson(Json json) {
        Builder builder = ImmutableKeywordNames.builder();
        if (json.getLongIsSet) {
            builder.setLong(json.getLong);
        }
        if (json.isDefaultIsSet) {
            builder.setDefault(json.isDefault);
        }
        return builder.build();
    }

    public static ImmutableKeywordNames copyOf(KeywordNames instance) {
        if (instance instanceof ImmutableKeywordNames) {
            return (ImmutableKeywordNames)instance;
        }
        return ImmutableKeywordNames.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeywordNames", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GET_LONG = 1L;
        private static final long INIT_BIT_IS_DEFAULT = 2L;
        private long initBits = 3L;
        private long getLong;
        private boolean isDefault;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeywordNames instance) {
            Objects.requireNonNull(instance, "instance");
            this.setLong(instance.getLong());
            this.setDefault(instance.isDefault());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder setLong(long getLong) {
            this.getLong = getLong;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder setDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableKeywordNames build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeywordNames(this.getLong, this.isDefault);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("long");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("default");
            }
            return "Cannot build KeywordNames, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="KeywordNames", generator="Immutables")
    static final class Json
    implements KeywordNames {
        long getLong;
        boolean getLongIsSet;
        boolean isDefault;
        boolean isDefaultIsSet;

        Json() {
        }

        @JsonProperty
        public void setLong(long getLong) {
            this.getLong = getLong;
            this.getLongIsSet = true;
        }

        @JsonProperty
        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.isDefaultIsSet = true;
        }

        @Override
        public long getLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefault() {
            throw new UnsupportedOperationException();
        }
    }
}

