/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.CustomBuilderDeserialize;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="CustomBuilderDeserialize", generator="Immutables")
@Immutable
public final class ImmutableCustomBuilderDeserialize
extends CustomBuilderDeserialize {
    @Nullable
    private final Object value;
    private final int a;
    @Nullable
    private final String s;
    private final ImmutableList<Boolean> l;

    private ImmutableCustomBuilderDeserialize(@Nullable Object value, int a, @Nullable String s, ImmutableList<Boolean> l) {
        this.value = value;
        this.a = a;
        this.s = s;
        this.l = l;
    }

    @Override
    @JsonProperty(value="value")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="I", value=Integer.class), @JsonSubTypes.Type(name="O", value=Double.class)})
    @Nullable
    public Object value() {
        return this.value;
    }

    @Override
    @JsonProperty(value="a")
    public int a() {
        return this.a;
    }

    @Override
    @JsonProperty(value="s")
    @Nullable
    public String s() {
        return this.s;
    }

    @JsonProperty(value="l")
    public ImmutableList<Boolean> l() {
        return this.l;
    }

    public final ImmutableCustomBuilderDeserialize withValue(@Nullable Object value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableCustomBuilderDeserialize(value, this.a, this.s, this.l);
    }

    public final ImmutableCustomBuilderDeserialize withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableCustomBuilderDeserialize(this.value, value, this.s, this.l);
    }

    public final ImmutableCustomBuilderDeserialize withS(@Nullable String value) {
        if (Objects.equals(this.s, value)) {
            return this;
        }
        return new ImmutableCustomBuilderDeserialize(this.value, this.a, value, this.l);
    }

    public final ImmutableCustomBuilderDeserialize withL(boolean ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Booleans.asList((boolean[])elements));
        return new ImmutableCustomBuilderDeserialize(this.value, this.a, this.s, (ImmutableList<Boolean>)newValue);
    }

    public final ImmutableCustomBuilderDeserialize withL(Iterable<Boolean> elements) {
        if (this.l == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCustomBuilderDeserialize(this.value, this.a, this.s, (ImmutableList<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomBuilderDeserialize && this.equalTo(0, (ImmutableCustomBuilderDeserialize)another);
    }

    private boolean equalTo(int synthetic, ImmutableCustomBuilderDeserialize another) {
        return Objects.equals(this.value, another.value) && this.a == another.a && Objects.equals(this.s, another.s) && this.l.equals(another.l);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + this.a;
        h += (h << 5) + Objects.hashCode(this.s);
        h += (h << 5) + this.l.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomBuilderDeserialize").omitNullValues().add("value", this.value).add("a", this.a).add("s", (Object)this.s).add("l", this.l).toString();
    }

    public static ImmutableCustomBuilderDeserialize copyOf(CustomBuilderDeserialize instance) {
        if (instance instanceof ImmutableCustomBuilderDeserialize) {
            return (ImmutableCustomBuilderDeserialize)instance;
        }
        return new Builder().from(instance).build();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="CustomBuilderDeserialize", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private long initBits = 1L;
        @Nullable
        private Object value;
        private int a;
        @Nullable
        private String s;
        private ImmutableList.Builder<Boolean> l = ImmutableList.builder();

        @CanIgnoreReturnValue
        public final Builder from(CustomBuilderDeserialize instance) {
            Objects.requireNonNull(instance, "instance");
            Object valueValue = instance.value();
            if (valueValue != null) {
                this.value(valueValue);
            }
            this.a(instance.a());
            String sValue = instance.s();
            if (sValue != null) {
                this.s(sValue);
            }
            this.addAllL(instance.l());
            return this;
        }

        @JsonProperty(value="value")
        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
        @JsonSubTypes(value={@JsonSubTypes.Type(name="I", value=Integer.class), @JsonSubTypes.Type(name="O", value=Double.class)})
        @CanIgnoreReturnValue
        public final Builder value(@Nullable Object value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="a")
        @CanIgnoreReturnValue
        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="s")
        @CanIgnoreReturnValue
        public final Builder s(@Nullable String s) {
            this.s = s;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addL(boolean element) {
            this.l.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addL(boolean ... elements) {
            this.l.addAll((Iterable)Booleans.asList((boolean[])elements));
            return this;
        }

        @JsonProperty(value="l")
        @CanIgnoreReturnValue
        public final Builder l(Iterable<Boolean> elements) {
            this.l = ImmutableList.builder();
            return this.addAllL(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllL(Iterable<Boolean> elements) {
            this.l.addAll(elements);
            return this;
        }

        public ImmutableCustomBuilderDeserialize build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomBuilderDeserialize(this.value, this.a, this.s, this.l.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build CustomBuilderDeserialize, some of required attributes are not set " + attributes;
        }
    }
}

