/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.AttributeIs;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AttributeIs", generator="Immutables")
@Immutable
public final class ImmutableAttributeIs
implements AttributeIs {
    private final boolean isEmpty;
    private final boolean empty;

    private ImmutableAttributeIs(boolean isEmpty, boolean empty) {
        this.isEmpty = isEmpty;
        this.empty = empty;
    }

    @Override
    @JsonProperty(value="isEmpty")
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    @JsonProperty(value="empty")
    public boolean getEmpty() {
        return this.empty;
    }

    public final ImmutableAttributeIs withIsEmpty(boolean value) {
        if (this.isEmpty == value) {
            return this;
        }
        return new ImmutableAttributeIs(value, this.empty);
    }

    public final ImmutableAttributeIs withEmpty(boolean value) {
        if (this.empty == value) {
            return this;
        }
        return new ImmutableAttributeIs(this.isEmpty, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttributeIs && this.equalTo(0, (ImmutableAttributeIs)another);
    }

    private boolean equalTo(int synthetic, ImmutableAttributeIs another) {
        return this.isEmpty == another.isEmpty && this.empty == another.empty;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.isEmpty);
        h += (h << 5) + Booleans.hashCode((boolean)this.empty);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AttributeIs").omitNullValues().add("isEmpty", this.isEmpty).add("empty", this.empty).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAttributeIs fromJson(Json json) {
        Builder builder = ImmutableAttributeIs.builder();
        if (json.isEmptyIsSet) {
            builder.isEmpty(json.isEmpty);
        }
        if (json.emptyIsSet) {
            builder.empty(json.empty);
        }
        return builder.build();
    }

    public static ImmutableAttributeIs copyOf(AttributeIs instance) {
        if (instance instanceof ImmutableAttributeIs) {
            return (ImmutableAttributeIs)instance;
        }
        return ImmutableAttributeIs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AttributeIs", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_EMPTY = 1L;
        private static final long INIT_BIT_EMPTY = 2L;
        private long initBits = 3L;
        private boolean isEmpty;
        private boolean empty;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AttributeIs instance) {
            Objects.requireNonNull(instance, "instance");
            this.isEmpty(instance.isEmpty());
            this.empty(instance.getEmpty());
            return this;
        }

        @JsonProperty(value="isEmpty")
        @CanIgnoreReturnValue
        public final Builder isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="empty")
        @CanIgnoreReturnValue
        public final Builder empty(boolean empty) {
            this.empty = empty;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAttributeIs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAttributeIs(this.isEmpty, this.empty);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isEmpty");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("empty");
            }
            return "Cannot build AttributeIs, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AttributeIs", generator="Immutables")
    static final class Json
    implements AttributeIs {
        boolean isEmpty;
        boolean isEmptyIsSet;
        boolean empty;
        boolean emptyIsSet;

        Json() {
        }

        @JsonProperty(value="isEmpty")
        public void setIsEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
            this.isEmptyIsSet = true;
        }

        @JsonProperty(value="empty")
        public void setEmpty(boolean empty) {
            this.empty = empty;
            this.emptyIsSet = true;
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getEmpty() {
            throw new UnsupportedOperationException();
        }
    }
}

