/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.generics.Firstie;
import org.immutables.fixture.generics.ModifiableFirstie;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Firstie", generator="Immutables")
@Immutable
public final class ImmutableFirstie<T, V extends Runnable & Serializable>
implements Firstie<T, V> {
    private final T ref;
    private final ImmutableList<V> commands;

    private ImmutableFirstie(T ref, ImmutableList<V> commands) {
        this.ref = ref;
        this.commands = commands;
    }

    @Override
    public T ref() {
        return this.ref;
    }

    @Override
    public ImmutableList<V> commands() {
        return this.commands;
    }

    public final ImmutableFirstie<T, V> withRef(T value) {
        if (this.ref == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "ref");
        return new ImmutableFirstie<T, V>(newValue, this.commands);
    }

    @SafeVarargs
    public final ImmutableFirstie<T, V> withCommands(V ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFirstie<T, V>(this.ref, newValue);
    }

    public final ImmutableFirstie<T, V> withCommands(Iterable<? extends V> elements) {
        if (this.commands == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFirstie<T, V>(this.ref, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFirstie && this.equalTo(0, (ImmutableFirstie)another);
    }

    private boolean equalTo(int synthetic, ImmutableFirstie<?, ?> another) {
        return this.ref.equals(another.ref) && this.commands.equals(another.commands);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ref.hashCode();
        h += (h << 5) + this.commands.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Firstie").omitNullValues().add("ref", this.ref).add("commands", this.commands).toString();
    }

    public static <T, V extends Runnable & Serializable> ImmutableFirstie<T, V> copyOf(Firstie<T, V> instance) {
        if (instance instanceof ImmutableFirstie) {
            return (ImmutableFirstie)instance;
        }
        return ImmutableFirstie.builder().from(instance).build();
    }

    public static <T, V extends Runnable & Serializable> Builder<T, V> builder() {
        return new Builder();
    }

    @Generated(from="Firstie", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T, V extends Runnable & Serializable> {
        private static final long INIT_BIT_REF = 1L;
        private long initBits = 1L;
        @Nullable
        private T ref;
        private ImmutableList.Builder<V> commands = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T, V> from(ModifiableFirstie<T, V> instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance.refIsSet()) {
                this.ref(instance.ref());
            }
            this.addAllCommands(instance.commands());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, V> from(Firstie<T, V> instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableFirstie) {
                return this.from((ModifiableFirstie)instance);
            }
            this.ref(instance.ref());
            this.addAllCommands(instance.commands());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, V> ref(T ref) {
            this.ref = Objects.requireNonNull(ref, "ref");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, V> addCommands(V element) {
            this.commands.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<T, V> addCommands(V ... elements) {
            this.commands.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, V> commands(Iterable<? extends V> elements) {
            this.commands = ImmutableList.builder();
            return this.addAllCommands(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<T, V> addAllCommands(Iterable<? extends V> elements) {
            this.commands.addAll(elements);
            return this;
        }

        public ImmutableFirstie<T, V> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFirstie(this.ref, this.commands.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ref");
            }
            return "Cannot build Firstie, some of required attributes are not set " + attributes;
        }
    }
}

