/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.generics.AbstractValidate;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractValidate.Concrete1", generator="Immutables")
@Immutable
public final class ImmutableConcrete1<T>
extends AbstractValidate.Concrete1<T> {
    private final T reference;

    private ImmutableConcrete1(T reference) {
        this.reference = Objects.requireNonNull(reference, "reference");
    }

    private ImmutableConcrete1(ImmutableConcrete1<T> original, T reference) {
        this.reference = reference;
    }

    @Override
    T reference() {
        return this.reference;
    }

    public final ImmutableConcrete1<T> withReference(T value) {
        if (this.reference == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "reference");
        return ImmutableConcrete1.validate(new ImmutableConcrete1<T>(this, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConcrete1 && this.equalTo(0, (ImmutableConcrete1)another);
    }

    private boolean equalTo(int synthetic, ImmutableConcrete1<?> another) {
        return this.reference.equals(another.reference);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.reference.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Concrete1").omitNullValues().add("reference", this.reference).toString();
    }

    public static <T> ImmutableConcrete1<T> of(T reference) {
        return ImmutableConcrete1.validate(new ImmutableConcrete1<T>(reference));
    }

    private static <T> ImmutableConcrete1<T> validate(ImmutableConcrete1<T> instance) {
        instance = (ImmutableConcrete1)instance.check();
        return instance;
    }

    public static <T> ImmutableConcrete1<T> copyOf(AbstractValidate.Concrete1<T> instance) {
        if (instance instanceof ImmutableConcrete1) {
            return (ImmutableConcrete1)instance;
        }
        return ImmutableConcrete1.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="AbstractValidate.Concrete1", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_REFERENCE = 1L;
        private long initBits = 1L;
        @Nullable
        private T reference;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(AbstractValidate.Concrete1<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.reference(instance.reference());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> reference(T reference) {
            this.reference = Objects.requireNonNull(reference, "reference");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableConcrete1<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableConcrete1.validate(new ImmutableConcrete1(null, this.reference));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reference");
            }
            return "Cannot build Concrete1, some of required attributes are not set " + attributes;
        }
    }
}

