/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.generics.GenericSubType;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenericSubType.B", generator="Immutables")
@Immutable
public final class ImmutableB<T>
implements GenericSubType.B<T> {
    private final int a;
    private final T b;

    private ImmutableB(int a, T b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public int a() {
        return this.a;
    }

    @Override
    public T b() {
        return this.b;
    }

    public final ImmutableB<T> withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableB<T>(value, this.b);
    }

    public final ImmutableB<T> withB(T value) {
        if (this.b == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "b");
        return new ImmutableB<T>(this.a, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableB && this.equalTo(0, (ImmutableB)another);
    }

    private boolean equalTo(int synthetic, ImmutableB<?> another) {
        return this.a == another.a && this.b.equals(another.b);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a;
        h += (h << 5) + this.b.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"B").omitNullValues().add("a", this.a).add("b", this.b).toString();
    }

    public static <T> ImmutableB<T> copyOf(GenericSubType.B<T> instance) {
        if (instance instanceof ImmutableB) {
            return (ImmutableB)instance;
        }
        return ImmutableB.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="GenericSubType.B", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private long initBits = 3L;
        private int a;
        @Nullable
        private T b;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(GenericSubType.B<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(GenericSubType.A instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GenericSubType.A instance;
            long bits = 0L;
            if (object instanceof GenericSubType.B) {
                instance = (GenericSubType.B)object;
                if ((bits & 1L) == 0L) {
                    this.a(instance.a());
                    bits |= 1L;
                }
                this.b(instance.b());
            }
            if (object instanceof GenericSubType.A) {
                instance = (GenericSubType.A)object;
                if ((bits & 1L) == 0L) {
                    this.a(instance.a());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> b(T b) {
            this.b = Objects.requireNonNull(b, "b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableB<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableB(this.a, this.b);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            return "Cannot build B, some of required attributes are not set " + attributes;
        }
    }
}

