/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.encoding.defs;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

class OptionalMap<K, V> {
    private final ImmutableMap<K, V> map = null;

    OptionalMap() {
    }

    public Optional<Map<K, V>> get() {
        return Optional.ofNullable(this.map);
    }

    public Optional<ImmutableMap<K, V>> getImmutable() {
        return Optional.ofNullable(this.map);
    }

    public int hashCode() {
        return Objects.hashCode(this.map);
    }

    public String toString() {
        return this.get().toString();
    }

    boolean equals(OptionalMap<K, V> obj) {
        return Objects.equals(this.map, obj.map);
    }

    @Nullable
    static <K, V> ImmutableMap<K, V> init(Optional<? extends Map<K, V>> map) {
        return map.isPresent() ? ImmutableMap.copyOf(map.get()) : null;
    }

    static class Builder<K, V> {
        @Nullable
        private ImmutableMap.Builder<K, V> builder = null;

        Builder() {
        }

        void put(K row, V value) {
            this.nonnullBuilder().put(row, value);
        }

        void putAll(Map<? extends K, ? extends V> entries) {
            this.nonnullBuilder().putAll(entries);
        }

        void set(Optional<? extends Map<K, V>> entries) {
            this.builder = null;
            if (entries.isPresent()) {
                this.nonnullBuilder().putAll(entries.get());
            }
        }

        private ImmutableMap.Builder<K, V> nonnullBuilder() {
            return this.builder == null ? (this.builder = ImmutableMap.builder()) : this.builder;
        }

        @Nullable
        ImmutableMap<K, V> build() {
            return this.builder != null ? this.builder.build() : null;
        }
    }
}

