/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.encoding.defs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class OptionalList<T> {
    private final List<T> list = null;

    OptionalList() {
    }

    public Optional<List<T>> get() {
        return Optional.ofNullable(this.list);
    }

    static <T> List<T> init(Optional<? extends List<T>> lst) {
        return lst.map(ArrayList::new).orElse(null);
    }

    public String toString() {
        return this.get().toString();
    }

    public int hashCode() {
        return this.get().hashCode();
    }

    public boolean equals(OptionalList<T> obj) {
        return Objects.equals(this.list, obj.list);
    }

    static final class Builder<T> {
        private List<T> list = null;

        Builder() {
        }

        void add(T element) {
            this.getOrCreate().add(element);
        }

        void addAll(List<? extends T> elements) {
            this.getOrCreate().addAll(elements);
        }

        List<T> build() {
            return this.list;
        }

        void set(Optional<? extends List<? extends T>> elements) {
            this.list = null;
            elements.ifPresent(e -> this.getOrCreate().addAll((Collection<T>)e));
        }

        private List<T> getOrCreate() {
            if (this.list == null) {
                this.list = new ArrayList<T>();
            }
            return this.list;
        }
    }
}

