/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.Canvas;
import org.immutables.fixture.deep.ImmutableColor;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Canvas.Color", generator="Modifiables")
@NotThreadSafe
public final class ModifiableColor
implements Canvas.Color {
    private static final long INIT_BIT_RED = 1L;
    private static final long INIT_BIT_GREEN = 2L;
    private static final long INIT_BIT_BLUE = 4L;
    private long initBits = 7L;
    private double red;
    private double green;
    private double blue;

    private ModifiableColor() {
    }

    public static ModifiableColor create(double red, double green, double blue) {
        return new ModifiableColor().setRed(red).setGreen(green).setBlue(blue);
    }

    public static ModifiableColor create() {
        return new ModifiableColor();
    }

    @Override
    public final double red() {
        if (!this.redIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.red;
    }

    @Override
    public final double green() {
        if (!this.greenIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.green;
    }

    @Override
    public final double blue() {
        if (!this.blueIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.blue;
    }

    @CanIgnoreReturnValue
    public ModifiableColor clear() {
        this.initBits = 7L;
        this.red = 0.0;
        this.green = 0.0;
        this.blue = 0.0;
        return this;
    }

    public ModifiableColor from(Canvas.Color instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableColor) {
            this.from((ModifiableColor)instance);
            return this;
        }
        this.setRed(instance.red());
        this.setGreen(instance.green());
        this.setBlue(instance.blue());
        return this;
    }

    public ModifiableColor from(ModifiableColor instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance.redIsSet()) {
            this.setRed(instance.red());
        }
        if (instance.greenIsSet()) {
            this.setGreen(instance.green());
        }
        if (instance.blueIsSet()) {
            this.setBlue(instance.blue());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableColor setRed(double red) {
        this.red = red;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableColor setGreen(double green) {
        this.green = green;
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableColor setBlue(double blue) {
        this.blue = blue;
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final boolean redIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean greenIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    public final boolean blueIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    @CanIgnoreReturnValue
    public final ModifiableColor unsetRed() {
        this.initBits |= 1L;
        this.red = 0.0;
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableColor unsetGreen() {
        this.initBits |= 2L;
        this.green = 0.0;
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableColor unsetBlue() {
        this.initBits |= 4L;
        this.blue = 0.0;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.redIsSet()) {
            attributes.add("red");
        }
        if (!this.greenIsSet()) {
            attributes.add("green");
        }
        if (!this.blueIsSet()) {
            attributes.add("blue");
        }
        return "Color is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableColor toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableColor.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableColor)) {
            return false;
        }
        ModifiableColor other = (ModifiableColor)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableColor another) {
        return Double.doubleToLongBits(this.red) == Double.doubleToLongBits(another.red) && Double.doubleToLongBits(this.green) == Double.doubleToLongBits(another.green) && Double.doubleToLongBits(this.blue) == Double.doubleToLongBits(another.blue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Doubles.hashCode((double)this.red);
        h += (h << 5) + Doubles.hashCode((double)this.green);
        h += (h << 5) + Doubles.hashCode((double)this.blue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableColor").add("red", this.redIsSet() ? Double.valueOf(this.red()) : "?").add("green", this.greenIsSet() ? Double.valueOf(this.green()) : "?").add("blue", this.blueIsSet() ? Double.valueOf(this.blue()) : "?").toString();
    }
}

