/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import java.util.List;
import java.util.Optional;
import org.immutables.fixture.deep.ImmutableColor;
import org.immutables.fixture.deep.ImmutableLine;
import org.immutables.value.Value;

@Value.Style(deepImmutablesDetection=true, depluralize=true)
public interface Canvas {
    default public void use() {
        ImmutableLine line = ImmutableLine.builder().color(0.9, 0.7, 0.4).addPoint(1, 2).addPoint(2, 3).addPoint(4, 5).build();
        ImmutableColor color = line.color();
        ImmutableLine.builder().addAllPoints((Iterable<? extends Point>)line.points()).color(color).shadow(0.2, 0.2, 0.2).build();
    }

    @Value.Modifiable
    @Value.Immutable
    public static interface Point {
        @Value.Parameter
        public int x();

        @Value.Parameter
        public int y();
    }

    @Value.Modifiable
    @Value.Immutable
    public static interface Line {
        public List<Point> points();

        public Color color();

        public Optional<Color> shadow();
    }

    @Value.Modifiable
    @Value.Immutable
    public static interface Color {
        @Value.Parameter
        public double red();

        @Value.Parameter
        public double green();

        @Value.Parameter
        public double blue();
    }
}

