/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.builder.ToBuilderMethod;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ToBuilderMethod.ToBuilderClassic", generator="Immutables")
@Immutable
public final class ImmutableToBuilderClassic
implements ToBuilderMethod.ToBuilderClassic {
    private final int a;
    private final String b;

    private ImmutableToBuilderClassic(int a, String b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public int a() {
        return this.a;
    }

    @Override
    public String b() {
        return this.b;
    }

    public final ImmutableToBuilderClassic withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableToBuilderClassic(value, this.b);
    }

    public final ImmutableToBuilderClassic withB(String value) {
        String newValue = Objects.requireNonNull(value, "b");
        if (this.b.equals(newValue)) {
            return this;
        }
        return new ImmutableToBuilderClassic(this.a, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToBuilderClassic && this.equalTo(0, (ImmutableToBuilderClassic)another);
    }

    private boolean equalTo(int synthetic, ImmutableToBuilderClassic another) {
        return this.a == another.a && this.b.equals(another.b);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a;
        h += (h << 5) + this.b.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ToBuilderClassic").omitNullValues().add("a", this.a).add("b", (Object)this.b).toString();
    }

    public static ImmutableToBuilderClassic copyOf(ToBuilderMethod.ToBuilderClassic instance) {
        if (instance instanceof ImmutableToBuilderClassic) {
            return (ImmutableToBuilderClassic)instance;
        }
        return ImmutableToBuilderClassic.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableToBuilderClassic.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ToBuilderMethod.ToBuilderClassic", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private long initBits = 3L;
        private int a;
        @Nullable
        private String b;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ToBuilderMethod.ToBuilderClassic instance) {
            Objects.requireNonNull(instance, "instance");
            this.a(instance.a());
            this.b(instance.b());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder b(String b) {
            this.b = Objects.requireNonNull(b, "b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableToBuilderClassic build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToBuilderClassic(this.a, this.b);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            return "Cannot build ToBuilderClassic, some of required attributes are not set " + attributes;
        }
    }
}

