/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.builder.One;
import org.immutables.fixture.builder.OneAndTwo;
import org.immutables.fixture.builder.OneAndTwoConcrete;
import org.immutables.fixture.builder.Two;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OneAndTwoConcrete", generator="Immutables")
@Immutable
final class ImmutableOneAndTwoConcrete
implements OneAndTwoConcrete {
    private final String one;
    private final String two;

    private ImmutableOneAndTwoConcrete(String one, String two) {
        this.one = one;
        this.two = two;
    }

    @Override
    public String one() {
        return this.one;
    }

    @Override
    public String two() {
        return this.two;
    }

    public final ImmutableOneAndTwoConcrete withOne(String value) {
        String newValue = Objects.requireNonNull(value, "one");
        if (this.one.equals(newValue)) {
            return this;
        }
        return new ImmutableOneAndTwoConcrete(newValue, this.two);
    }

    public final ImmutableOneAndTwoConcrete withTwo(String value) {
        String newValue = Objects.requireNonNull(value, "two");
        if (this.two.equals(newValue)) {
            return this;
        }
        return new ImmutableOneAndTwoConcrete(this.one, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOneAndTwoConcrete && this.equalTo(0, (ImmutableOneAndTwoConcrete)another);
    }

    private boolean equalTo(int synthetic, ImmutableOneAndTwoConcrete another) {
        return this.one.equals(another.one) && this.two.equals(another.two);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.one.hashCode();
        h += (h << 5) + this.two.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OneAndTwoConcrete").omitNullValues().add("one", (Object)this.one).add("two", (Object)this.two).toString();
    }

    public static ImmutableOneAndTwoConcrete copyOf(OneAndTwoConcrete instance) {
        if (instance instanceof ImmutableOneAndTwoConcrete) {
            return (ImmutableOneAndTwoConcrete)instance;
        }
        return ImmutableOneAndTwoConcrete.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OneAndTwoConcrete", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ONE = 1L;
        private static final long INIT_BIT_TWO = 2L;
        private long initBits = 3L;
        @Nullable
        private String one;
        @Nullable
        private String two;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OneAndTwoConcrete instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(OneAndTwo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(One instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Two instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof OneAndTwoConcrete) {
                instance = (OneAndTwoConcrete)object;
                if ((bits & 2L) == 0L) {
                    this.two(instance.two());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.one(instance.one());
                    bits |= 1L;
                }
            }
            if (object instanceof OneAndTwo) {
                instance = (OneAndTwo)object;
                if ((bits & 2L) == 0L) {
                    this.two(instance.two());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.one(instance.one());
                    bits |= 1L;
                }
            }
            if (object instanceof One) {
                instance = (One)object;
                if ((bits & 1L) == 0L) {
                    this.one(instance.one());
                    bits |= 1L;
                }
            }
            if (object instanceof Two) {
                instance = (Two)object;
                if ((bits & 2L) == 0L) {
                    this.two(instance.two());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder one(String one) {
            this.one = Objects.requireNonNull(one, "one");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder two(String two) {
            this.two = Objects.requireNonNull(two, "two");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableOneAndTwoConcrete build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOneAndTwoConcrete(this.one, this.two);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("one");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("two");
            }
            return "Cannot build OneAndTwoConcrete, some of required attributes are not set " + attributes;
        }
    }
}

