/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.annotation.NoDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NoDefault", generator="Immutables")
@Immutable
final class ImmutableNoDefault
implements NoDefault {
    private final int value;
    private final String otherValue;

    private ImmutableNoDefault(int value, String otherValue) {
        this.value = value;
        this.otherValue = otherValue;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return NoDefault.class;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public String otherValue() {
        return this.otherValue;
    }

    public final ImmutableNoDefault withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableNoDefault(value, this.otherValue);
    }

    public final ImmutableNoDefault withOtherValue(String value) {
        String newValue = Objects.requireNonNull(value, "otherValue");
        if (this.otherValue.equals(newValue)) {
            return this;
        }
        return new ImmutableNoDefault(this.value, newValue);
    }

    @Override
    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NoDefault && this.equalTo(0, (NoDefault)another);
    }

    private boolean equalTo(int synthetic, NoDefault another) {
        return this.value == another.value() && this.otherValue.equals(another.otherValue());
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "value".hashCode() ^ this.value;
        return h += 127 * "otherValue".hashCode() ^ this.otherValue.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"@NoDefault").omitNullValues().add("value", this.value).add("otherValue", (Object)this.otherValue).toString();
    }

    public static ImmutableNoDefault copyOf(NoDefault instance) {
        if (instance instanceof ImmutableNoDefault) {
            return (ImmutableNoDefault)instance;
        }
        return ImmutableNoDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NoDefault", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_OTHER_VALUE = 2L;
        private long initBits = 3L;
        private int value;
        @Nullable
        private String otherValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NoDefault instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            this.otherValue(instance.otherValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder otherValue(String otherValue) {
            this.otherValue = Objects.requireNonNull(otherValue, "otherValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableNoDefault build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNoDefault(this.value, this.otherValue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("otherValue");
            }
            return "Cannot build NoDefault, some of required attributes are not set " + attributes;
        }
    }
}

