/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedInteger;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.fixture.SillyEntity;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SillyEntity", generator="Repositories")
@ThreadSafe
public class SillyEntityRepository
extends Repositories.Repository<SillyEntity> {
    private static final String DOCUMENT_COLLECTION_NAME = "sillyEntity";
    private final Serialization serialization = new Serialization(this.codecRegistry(), this.fieldNamingStrategy());
    private final Criteria anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());

    public SillyEntityRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, SillyEntity.class);
    }

    public FluentFuture<Integer> insert(SillyEntity document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends SillyEntity> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    @CheckReturnValue
    public Finder findAll() {
        return this.find(this.criteria());
    }

    @CheckReturnValue
    public Finder find(String jsonCriteria) {
        return new Finder(this, Support.jsonQuery((String)jsonCriteria));
    }

    @CheckReturnValue
    public Finder findById(int id) {
        return this.find(this.criteria().id(id));
    }

    public FluentFuture<Integer> upsert(SillyEntity document) {
        Criteria byId = this.criteria().id(document.id());
        return super.doUpsert((Constraints.ConstraintHost)byId.constraint, (Object)document);
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, (Constraints.ConstraintHost)criteria.constraint);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public Criteria criteria() {
        return this.anyCriteria;
    }

    @Beta
    Bson toBson(Criteria criteria) {
        return Support.convertToBson((Constraints.ConstraintHost)criteria.constraint);
    }

    @Generated(from="SillyEntity", generator="Repositories")
    private static class Serialization {
        final Encoder<Integer> payloadSecondaryEncoder;
        final Encoder<Integer> intsEncoder;
        final Encoder<UnsignedInteger> derEncoder;
        final CodecRegistry registry;
        final String idName;
        final String valName;
        final String payloadName;
        final String intsName;
        final String derName;

        Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
            this.registry = registry;
            this.payloadSecondaryEncoder = this.registry.get(Integer.class);
            this.intsEncoder = this.registry.get(Integer.class);
            this.derEncoder = this.registry.get(UnsignedInteger.class);
            this.idName = "_id";
            this.valName = "v";
            this.payloadName = "p";
            this.intsName = "i";
            this.derName = Serialization.translateName(fieldNamingStrategy, "der");
        }

        private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
            try {
                return fieldNamingStrategy.translateName((Member)SillyEntityNamingFields.class.getField(fieldName));
            }
            catch (NoSuchFieldException noSuchField) {
                throw new AssertionError((Object)noSuchField);
            }
        }

        @Generated(from="SillyEntity", generator="Repositories")
        static final class SillyEntityNamingFields {
            public int id;
            public String val;
            public Map<String, Integer> payload;
            public List<Integer> ints;
            public UnsignedInteger der;

            SillyEntityNamingFields() {
            }
        }
    }

    @Generated(from="SillyEntity", generator="Repositories")
    @Immutable
    public static final class Criteria
    extends Repositories.Criteria {
        private final Constraints.Constraint constraint;
        private final Serialization serialization;

        Criteria(Serialization serialization, Constraints.Constraint constraint) {
            this.constraint = constraint;
            this.serialization = serialization;
        }

        public Criteria id(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, false, Support.writable((Object)value)));
        }

        public Criteria idNot(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, true, Support.writable((Object)value)));
        }

        public Criteria idIn(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, wrappedValues));
        }

        public Criteria idIn(int first, int second, int ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, values));
        }

        public Criteria idNotIn(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, wrappedValues));
        }

        public Criteria idNotIn(int first, int second, int ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (int value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, values));
        }

        public Criteria idGreaterThan(int lower) {
            return this.idIn((Range<Integer>)Range.greaterThan((Comparable)Integer.valueOf(lower)));
        }

        public Criteria idLessThan(int upper) {
            return this.idIn((Range<Integer>)Range.lessThan((Comparable)Integer.valueOf(upper)));
        }

        public Criteria idAtMost(int upperInclusive) {
            return this.idIn((Range<Integer>)Range.atMost((Comparable)Integer.valueOf(upperInclusive)));
        }

        public Criteria idAtLeast(int lowerInclusive) {
            return this.idIn((Range<Integer>)Range.atLeast((Comparable)Integer.valueOf(lowerInclusive)));
        }

        public Criteria idIn(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, false, Support.writable(range)));
        }

        public Criteria idNotIn(Range<Integer> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, true, Support.writable(range)));
        }

        public Criteria val(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.valName, false, Support.writable((Object)value)));
        }

        public Criteria valNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.valName, true, Support.writable((Object)value)));
        }

        public Criteria valIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.valName, false, wrappedValues));
        }

        public Criteria valIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.valName, false, values));
        }

        public Criteria valNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.valName, true, wrappedValues));
        }

        public Criteria valNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.valName, true, values));
        }

        public Criteria valStartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.valName, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria valMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.valName, false, pattern));
        }

        public Criteria valNotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.valName, true, pattern));
        }

        public Criteria valGreaterThan(String lower) {
            return this.valIn((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria valLessThan(String upper) {
            return this.valIn((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria valAtMost(String upperInclusive) {
            return this.valIn((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria valAtLeast(String lowerInclusive) {
            return this.valIn((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria valIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.valName, false, Support.writable(range)));
        }

        public Criteria valNotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.valName, true, Support.writable(range)));
        }

        public Criteria payload(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.payloadName, false, Support.writable((Object)value)));
        }

        public Criteria payloadNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.payloadName, true, Support.writable((Object)value)));
        }

        public Criteria payloadIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.payloadName, false, wrappedValues));
        }

        public Criteria payloadIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.payloadName, false, values));
        }

        public Criteria payloadNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.payloadName, true, wrappedValues));
        }

        public Criteria payloadNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.payloadName, true, values));
        }

        public Criteria intsEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.intsName, false, 0));
        }

        public Criteria intsNonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.intsName, true, 0));
        }

        public Criteria intsSize(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.intsName, false, size));
        }

        public Criteria intsContains(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.intsName, false, Support.writable(this.serialization.intsEncoder, (Object)value)));
        }

        public Criteria intsContainsAll(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.intsEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.intsName, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria der(UnsignedInteger value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.derName, false, Support.writable(this.serialization.derEncoder, (Object)value)));
        }

        public Criteria derNot(UnsignedInteger value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.derName, true, Support.writable(this.serialization.derEncoder, (Object)value)));
        }

        public Criteria derIn(Iterable<UnsignedInteger> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (UnsignedInteger value : values) {
                wrappedValues.add(Support.writable(this.serialization.derEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.derName, false, wrappedValues));
        }

        public Criteria derIn(UnsignedInteger first, UnsignedInteger second, UnsignedInteger ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.derEncoder, (Object)first));
            values.add(Support.writable(this.serialization.derEncoder, (Object)second));
            for (UnsignedInteger value : rest) {
                values.add(Support.writable(this.serialization.derEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.derName, false, values));
        }

        public Criteria derNotIn(Iterable<UnsignedInteger> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (UnsignedInteger value : values) {
                wrappedValues.add(Support.writable(this.serialization.derEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.derName, true, wrappedValues));
        }

        public Criteria derNotIn(UnsignedInteger first, UnsignedInteger second, UnsignedInteger ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.derEncoder, (Object)first));
            values.add(Support.writable(this.serialization.derEncoder, (Object)second));
            for (UnsignedInteger value : rest) {
                values.add(Support.writable(this.serialization.derEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.derName, true, values));
        }

        public Criteria derGreaterThan(UnsignedInteger lower) {
            return this.derIn((Range<UnsignedInteger>)Range.greaterThan((Comparable)lower));
        }

        public Criteria derLessThan(UnsignedInteger upper) {
            return this.derIn((Range<UnsignedInteger>)Range.lessThan((Comparable)upper));
        }

        public Criteria derAtMost(UnsignedInteger upperInclusive) {
            return this.derIn((Range<UnsignedInteger>)Range.atMost((Comparable)upperInclusive));
        }

        public Criteria derAtLeast(UnsignedInteger lowerInclusive) {
            return this.derIn((Range<UnsignedInteger>)Range.atLeast((Comparable)lowerInclusive));
        }

        public Criteria derIn(Range<UnsignedInteger> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.derName, false, Support.writable(this.serialization.derEncoder, range)));
        }

        public Criteria derNotIn(Range<UnsignedInteger> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.derName, true, Support.writable(this.serialization.derEncoder, range)));
        }

        public Criteria or() {
            return new Criteria(this.serialization, this.constraint.disjunction());
        }

        public Criteria with(Criteria criteria) {
            return new Criteria(this.serialization, (Constraints.Constraint)criteria.constraint.accept((Constraints.ConstraintVisitor)this.constraint));
        }

        public String toString() {
            return "SillyEntityRepository.criteria(" + Support.stringify((Constraints.ConstraintHost)this.constraint) + ")";
        }
    }

    @Generated(from="SillyEntity", generator="Repositories")
    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<SillyEntity, Indexer> {
        private final Serialization serialization;

        private Indexer(SillyEntityRepository repository) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
        }

        public Indexer withId() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Indexer withIdDesceding() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Indexer withVal() {
            this.fields = this.fields.equal(this.serialization.valName, false, (Object)1);
            return this;
        }

        public Indexer withValDesceding() {
            this.fields = this.fields.equal(this.serialization.valName, false, (Object)-1);
            return this;
        }

        public Indexer withPayload() {
            this.fields = this.fields.equal(this.serialization.payloadName, false, (Object)1);
            return this;
        }

        public Indexer withPayloadDesceding() {
            this.fields = this.fields.equal(this.serialization.payloadName, false, (Object)-1);
            return this;
        }

        public Indexer withInts() {
            this.fields = this.fields.equal(this.serialization.intsName, false, (Object)1);
            return this;
        }

        public Indexer withIntsDesceding() {
            this.fields = this.fields.equal(this.serialization.intsName, false, (Object)-1);
            return this;
        }

        public Indexer withDer() {
            this.fields = this.fields.equal(this.serialization.derName, false, (Object)1);
            return this;
        }

        public Indexer withDerDesceding() {
            this.fields = this.fields.equal(this.serialization.derName, false, (Object)-1);
            return this;
        }
    }

    @Generated(from="SillyEntity", generator="Repositories")
    @NotThreadSafe
    public static final class Replacer
    extends Repositories.Replacer<SillyEntity, Replacer> {
        protected Replacer(SillyEntityRepository repository, SillyEntity document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
            super((Repositories.Repository)repository, (Object)document, criteria, ordering);
        }
    }

    @Generated(from="SillyEntity", generator="Repositories")
    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<SillyEntity, Modifier> {
        private final Serialization serialization;

        private Modifier(SillyEntityRepository repository, Constraints.ConstraintHost criteria, Constraints.Constraint ordering, Constraints.Constraint exclusion) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setId(int value) {
            this.setFields = this.setFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initId(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier incrementId(int increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.idName, false, (Object)increment);
            return this;
        }

        public Modifier setVal(String value) {
            this.setFields = this.setFields.equal(this.serialization.valName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initVal(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.valName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier clearPayload() {
            this.setFields = this.setFields.equal(this.serialization.payloadName, false, Support.emptyBsonObject());
            return this;
        }

        public Modifier putPayload(String key, int value) {
            this.setFields = this.setFields.equal(this.serialization.payloadName + "." + key, false, Support.writable(this.serialization.payloadSecondaryEncoder, (Object)value));
            return this;
        }

        public Modifier removePayload(String key) {
            this.unsetFields = this.unsetFields.equal(this.serialization.payloadName + "." + key, false, (Object)1);
            return this;
        }

        public Modifier clearInts() {
            this.setFields = this.setFields.equal(this.serialization.intsName, false, (Object)ImmutableList.of());
            return this;
        }

        public Modifier removeInts(int value) {
            this.pullFields = this.pullFields.equal(this.serialization.intsName, false, Support.writable(this.serialization.intsEncoder, (Object)value));
            return this;
        }

        public Modifier addInts(int value) {
            this.pushFields = this.pushFields.equal(this.serialization.intsName, false, Support.writable(this.serialization.intsEncoder, (Object)value));
            return this;
        }

        public Modifier setInts(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.intsEncoder, (Object)value));
            }
            this.setFields = this.setFields.equal(this.serialization.intsName, false, wrappedValues);
            return this;
        }

        public Modifier addAllInts(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.intsEncoder, (Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.intsName, false, v);
            return this;
        }

        public Modifier setDer(UnsignedInteger value) {
            this.setFields = this.setFields.equal(this.serialization.derName, false, Support.writable(this.serialization.derEncoder, (Object)value));
            return this;
        }

        public Modifier initDer(UnsignedInteger value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.derName, false, Support.writable(this.serialization.derEncoder, (Object)value));
            return this;
        }
    }

    @Generated(from="SillyEntity", generator="Repositories")
    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<SillyEntity> {
        private final Serialization serialization;

        private Updater(SillyEntityRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria.constraint;
            this.serialization = repository.serialization;
        }

        public Updater setId(int value) {
            this.setFields = this.setFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Updater initId(int value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Updater incrementId(int increment) {
            this.incrementFields = this.incrementFields.equal(this.serialization.idName, false, (Object)increment);
            return this;
        }

        public Updater setVal(String value) {
            this.setFields = this.setFields.equal(this.serialization.valName, false, Support.writable((Object)value));
            return this;
        }

        public Updater initVal(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.valName, false, Support.writable((Object)value));
            return this;
        }

        public Updater clearPayload() {
            this.setFields = this.setFields.equal(this.serialization.payloadName, false, Support.emptyBsonObject());
            return this;
        }

        public Updater putPayload(String key, int value) {
            this.setFields = this.setFields.equal(this.serialization.payloadName + "." + key, false, Support.writable(this.serialization.payloadSecondaryEncoder, (Object)value));
            return this;
        }

        public Updater removePayload(String key) {
            this.unsetFields = this.unsetFields.equal(this.serialization.payloadName + "." + key, false, (Object)1);
            return this;
        }

        public Updater clearInts() {
            this.setFields = this.setFields.equal(this.serialization.intsName, false, (Object)ImmutableList.of());
            return this;
        }

        public Updater removeInts(int value) {
            this.pullFields = this.pullFields.equal(this.serialization.intsName, false, Support.writable(this.serialization.intsEncoder, (Object)value));
            return this;
        }

        public Updater addInts(int value) {
            this.pushFields = this.pushFields.equal(this.serialization.intsName, false, Support.writable(this.serialization.intsEncoder, (Object)value));
            return this;
        }

        public Updater setInts(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.intsEncoder, (Object)value));
            }
            this.setFields = this.setFields.equal(this.serialization.intsName, false, wrappedValues);
            return this;
        }

        public Updater addAllInts(Iterable<Integer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Integer value : values) {
                wrappedValues.add(Support.writable(this.serialization.intsEncoder, (Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.intsName, false, v);
            return this;
        }

        public Updater setDer(UnsignedInteger value) {
            this.setFields = this.setFields.equal(this.serialization.derName, false, Support.writable(this.serialization.derEncoder, (Object)value));
            return this;
        }

        public Updater initDer(UnsignedInteger value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.derName, false, Support.writable(this.serialization.derEncoder, (Object)value));
            return this;
        }
    }

    @Generated(from="SillyEntity", generator="Repositories")
    @NotThreadSafe
    public static final class Finder
    extends Repositories.FinderWithDelete<SillyEntity, Finder> {
        private final Serialization serialization;

        private Finder(SillyEntityRepository repository, Constraints.ConstraintHost criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria;
            this.serialization = repository.serialization;
        }

        public Finder orderById() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Finder orderByIdDesceding() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Finder orderByVal() {
            this.ordering = this.ordering.equal(this.serialization.valName, false, (Object)1);
            return this;
        }

        public Finder orderByValDesceding() {
            this.ordering = this.ordering.equal(this.serialization.valName, false, (Object)-1);
            return this;
        }

        public Finder orderByPayload() {
            this.ordering = this.ordering.equal(this.serialization.payloadName, false, (Object)1);
            return this;
        }

        public Finder orderByPayloadDesceding() {
            this.ordering = this.ordering.equal(this.serialization.payloadName, false, (Object)-1);
            return this;
        }

        public Finder orderByInts() {
            this.ordering = this.ordering.equal(this.serialization.intsName, false, (Object)1);
            return this;
        }

        public Finder orderByIntsDesceding() {
            this.ordering = this.ordering.equal(this.serialization.intsName, false, (Object)-1);
            return this;
        }

        public Finder orderByDer() {
            this.ordering = this.ordering.equal(this.serialization.derName, false, (Object)1);
            return this;
        }

        public Finder orderByDerDesceding() {
            this.ordering = this.ordering.equal(this.serialization.derName, false, (Object)-1);
            return this;
        }

        public Finder excludePayload() {
            this.exclusion = this.exclusion.equal(this.serialization.payloadName, false, (Object)-1);
            return this;
        }

        public Finder excludeInts() {
            this.exclusion = this.exclusion.equal(this.serialization.intsName, false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier((SillyEntityRepository)this.repository, this.criteria, this.ordering, this.exclusion);
        }

        @CheckReturnValue
        public Replacer andReplaceFirst(SillyEntity document) {
            return new Replacer((SillyEntityRepository)this.repository, document, this.criteria, this.ordering);
        }
    }
}

