/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.UseImmutableCollections;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UseImmutableCollections", generator="Immutables")
@Immutable
public final class ImmutableUseImmutableCollections
implements UseImmutableCollections {
    private final ImmutableList<String> list;
    private final ImmutableSet<Integer> set;
    private final ImmutableSet<RetentionPolicy> enumSet;
    private final ImmutableSortedSet<RetentionPolicy> sortedSet;
    private final ImmutableMultiset<String> multiset;
    private final ImmutableMap<String, Integer> map;
    private final ImmutableMap<RetentionPolicy, Integer> enumMap;
    private final ImmutableSortedMap<RetentionPolicy, Integer> sortedMap;
    private final ImmutableMultimap<String, Integer> multimap;
    private final ImmutableSetMultimap<String, Integer> setMultimap;
    private final ImmutableListMultimap<String, Integer> listMultimap;

    private ImmutableUseImmutableCollections(ImmutableList<String> list, ImmutableSet<Integer> set, ImmutableSet<RetentionPolicy> enumSet, ImmutableSortedSet<RetentionPolicy> sortedSet, ImmutableMultiset<String> multiset, ImmutableMap<String, Integer> map, ImmutableMap<RetentionPolicy, Integer> enumMap, ImmutableSortedMap<RetentionPolicy, Integer> sortedMap, ImmutableMultimap<String, Integer> multimap, ImmutableSetMultimap<String, Integer> setMultimap, ImmutableListMultimap<String, Integer> listMultimap) {
        this.list = list;
        this.set = set;
        this.enumSet = enumSet;
        this.sortedSet = sortedSet;
        this.multiset = multiset;
        this.map = map;
        this.enumMap = enumMap;
        this.sortedMap = sortedMap;
        this.multimap = multimap;
        this.setMultimap = setMultimap;
        this.listMultimap = listMultimap;
    }

    @Override
    public ImmutableList<String> list() {
        return this.list;
    }

    @Override
    public ImmutableSet<Integer> set() {
        return this.set;
    }

    @Override
    public ImmutableSet<RetentionPolicy> enumSet() {
        return this.enumSet;
    }

    @Override
    public ImmutableSortedSet<RetentionPolicy> sortedSet() {
        return this.sortedSet;
    }

    @Override
    public ImmutableMultiset<String> multiset() {
        return this.multiset;
    }

    @Override
    public ImmutableMap<String, Integer> map() {
        return this.map;
    }

    @Override
    public ImmutableMap<RetentionPolicy, Integer> enumMap() {
        return this.enumMap;
    }

    @Override
    public ImmutableSortedMap<RetentionPolicy, Integer> sortedMap() {
        return this.sortedMap;
    }

    @Override
    public ImmutableMultimap<String, Integer> multimap() {
        return this.multimap;
    }

    @Override
    public ImmutableSetMultimap<String, Integer> setMultimap() {
        return this.setMultimap;
    }

    @Override
    public ImmutableListMultimap<String, Integer> listMultimap() {
        return this.listMultimap;
    }

    public final ImmutableUseImmutableCollections withList(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableUseImmutableCollections((ImmutableList<String>)newValue, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withList(Iterable<String> elements) {
        if (this.list == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableUseImmutableCollections((ImmutableList<String>)newValue, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSet(int ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableUseImmutableCollections(this.list, (ImmutableSet<Integer>)newValue, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSet(Iterable<Integer> elements) {
        if (this.set == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableUseImmutableCollections(this.list, (ImmutableSet<Integer>)newValue, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withEnumSet(RetentionPolicy ... elements) {
        ImmutableSet newValue = Sets.immutableEnumSet(Arrays.asList(elements));
        return new ImmutableUseImmutableCollections(this.list, this.set, (ImmutableSet<RetentionPolicy>)newValue, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withEnumSet(Iterable<RetentionPolicy> elements) {
        if (this.enumSet == elements) {
            return this;
        }
        ImmutableSet newValue = Sets.immutableEnumSet(elements);
        return new ImmutableUseImmutableCollections(this.list, this.set, (ImmutableSet<RetentionPolicy>)newValue, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSortedSet(RetentionPolicy ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), Arrays.asList(elements));
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, (ImmutableSortedSet<RetentionPolicy>)newValue, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSortedSet(Iterable<? extends RetentionPolicy> elements) {
        if (this.sortedSet == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, (ImmutableSortedSet<RetentionPolicy>)newValue, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withMultiset(String ... elements) {
        ImmutableMultiset newValue = ImmutableMultiset.copyOf((Object[])elements);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, (ImmutableMultiset<String>)newValue, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withMultiset(Iterable<String> elements) {
        if (this.multiset == elements) {
            return this;
        }
        ImmutableMultiset newValue = ImmutableMultiset.copyOf(elements);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, (ImmutableMultiset<String>)newValue, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withMap(Map<String, ? extends Integer> entries) {
        if (this.map == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, (ImmutableMap<String, Integer>)newValue, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withEnumMap(Map<RetentionPolicy, ? extends Integer> entries) {
        if (this.enumMap == entries) {
            return this;
        }
        ImmutableMap newValue = Maps.immutableEnumMap(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, (ImmutableMap<RetentionPolicy, Integer>)newValue, this.sortedMap, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSortedMap(Map<? extends RetentionPolicy, ? extends Integer> entries) {
        if (this.sortedMap == entries) {
            return this;
        }
        ImmutableSortedMap newValue = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural().reverse());
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, (ImmutableSortedMap<RetentionPolicy, Integer>)newValue, this.multimap, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withMultimap(Multimap<String, ? extends Integer> entries) {
        if (this.multimap == entries) {
            return this;
        }
        ImmutableMultimap newValue = ImmutableMultimap.copyOf(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, (ImmutableMultimap<String, Integer>)newValue, this.setMultimap, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withSetMultimap(Multimap<String, ? extends Integer> entries) {
        if (this.setMultimap == entries) {
            return this;
        }
        ImmutableSetMultimap newValue = ImmutableSetMultimap.copyOf(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, (ImmutableSetMultimap<String, Integer>)newValue, this.listMultimap);
    }

    public final ImmutableUseImmutableCollections withListMultimap(Multimap<String, ? extends Integer> entries) {
        if (this.listMultimap == entries) {
            return this;
        }
        ImmutableListMultimap newValue = ImmutableListMultimap.copyOf(entries);
        return new ImmutableUseImmutableCollections(this.list, this.set, this.enumSet, this.sortedSet, this.multiset, this.map, this.enumMap, this.sortedMap, this.multimap, this.setMultimap, (ImmutableListMultimap<String, Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUseImmutableCollections && this.equalTo(0, (ImmutableUseImmutableCollections)another);
    }

    private boolean equalTo(int synthetic, ImmutableUseImmutableCollections another) {
        return this.list.equals(another.list) && this.set.equals(another.set) && this.enumSet.equals(another.enumSet) && this.sortedSet.equals(another.sortedSet) && this.multiset.equals(another.multiset) && this.map.equals(another.map) && this.enumMap.equals(another.enumMap) && this.sortedMap.equals(another.sortedMap) && this.multimap.equals(another.multimap) && this.setMultimap.equals(another.setMultimap) && this.listMultimap.equals(another.listMultimap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.list.hashCode();
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + this.enumSet.hashCode();
        h += (h << 5) + this.sortedSet.hashCode();
        h += (h << 5) + this.multiset.hashCode();
        h += (h << 5) + this.map.hashCode();
        h += (h << 5) + this.enumMap.hashCode();
        h += (h << 5) + this.sortedMap.hashCode();
        h += (h << 5) + this.multimap.hashCode();
        h += (h << 5) + this.setMultimap.hashCode();
        h += (h << 5) + this.listMultimap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UseImmutableCollections").omitNullValues().add("list", this.list).add("set", this.set).add("enumSet", this.enumSet).add("sortedSet", this.sortedSet).add("multiset", this.multiset).add("map", this.map).add("enumMap", this.enumMap).add("sortedMap", this.sortedMap).add("multimap", this.multimap).add("setMultimap", this.setMultimap).add("listMultimap", this.listMultimap).toString();
    }

    public static ImmutableUseImmutableCollections copyOf(UseImmutableCollections instance) {
        if (instance instanceof ImmutableUseImmutableCollections) {
            return (ImmutableUseImmutableCollections)instance;
        }
        return ImmutableUseImmutableCollections.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UseImmutableCollections", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> list = ImmutableList.builder();
        private ImmutableSet.Builder<Integer> set = ImmutableSet.builder();
        private ImmutableSet.Builder<RetentionPolicy> enumSet = ImmutableSet.builder();
        private ImmutableSortedSet.Builder<RetentionPolicy> sortedSet = ImmutableSortedSet.naturalOrder();
        private ImmutableMultiset.Builder<String> multiset = ImmutableMultiset.builder();
        private ImmutableMap.Builder<String, Integer> map = ImmutableMap.builder();
        private ImmutableMap.Builder<RetentionPolicy, Integer> enumMap = ImmutableMap.builder();
        private ImmutableSortedMap.Builder<RetentionPolicy, Integer> sortedMap = ImmutableSortedMap.reverseOrder();
        private ImmutableMultimap.Builder<String, Integer> multimap = ImmutableMultimap.builder();
        private ImmutableSetMultimap.Builder<String, Integer> setMultimap = ImmutableSetMultimap.builder();
        private ImmutableListMultimap.Builder<String, Integer> listMultimap = ImmutableListMultimap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UseImmutableCollections instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllList((Iterable<String>)instance.list());
            this.addAllSet((Iterable<Integer>)instance.set());
            this.addAllEnumSet((Iterable<RetentionPolicy>)instance.enumSet());
            this.addAllSortedSet((Iterable<? extends RetentionPolicy>)instance.sortedSet());
            this.addAllMultiset((Iterable<String>)instance.multiset());
            this.putAllMap((Map<String, ? extends Integer>)instance.map());
            this.putAllEnumMap((Map<RetentionPolicy, ? extends Integer>)instance.enumMap());
            this.putAllSortedMap((Map<? extends RetentionPolicy, ? extends Integer>)instance.sortedMap());
            this.putAllMultimap((Multimap<String, ? extends Integer>)instance.multimap());
            this.putAllSetMultimap((Multimap<String, ? extends Integer>)instance.setMultimap());
            this.putAllListMultimap((Multimap<String, ? extends Integer>)instance.listMultimap());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(String element) {
            this.list.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(String ... elements) {
            this.list.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder list(Iterable<String> elements) {
            this.list = ImmutableList.builder();
            return this.addAllList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllList(Iterable<String> elements) {
            this.list.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSet(int element) {
            this.set.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSet(int ... elements) {
            this.set.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder set(Iterable<Integer> elements) {
            this.set = ImmutableSet.builder();
            return this.addAllSet(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSet(Iterable<Integer> elements) {
            this.set.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEnumSet(RetentionPolicy element) {
            this.enumSet.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEnumSet(RetentionPolicy ... elements) {
            this.enumSet.addAll(Arrays.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enumSet(Iterable<RetentionPolicy> elements) {
            this.enumSet = ImmutableSet.builder();
            return this.addAllEnumSet(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEnumSet(Iterable<RetentionPolicy> elements) {
            this.enumSet.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSortedSet(RetentionPolicy element) {
            this.sortedSet.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSortedSet(RetentionPolicy ... elements) {
            this.sortedSet.addAll(Arrays.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortedSet(Iterable<? extends RetentionPolicy> elements) {
            this.sortedSet = ImmutableSortedSet.naturalOrder();
            return this.addAllSortedSet(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSortedSet(Iterable<? extends RetentionPolicy> elements) {
            this.sortedSet.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMultiset(String element) {
            this.multiset.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMultiset(String ... elements) {
            this.multiset.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder multiset(Iterable<String> elements) {
            this.multiset = ImmutableMultiset.builder();
            return this.addAllMultiset(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMultiset(Iterable<String> elements) {
            this.multiset.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(String key, int value) {
            this.map.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(Map.Entry<String, ? extends Integer> entry) {
            this.map.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder map(Map<String, ? extends Integer> entries) {
            this.map = ImmutableMap.builder();
            return this.putAllMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMap(Map<String, ? extends Integer> entries) {
            this.map.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEnumMap(RetentionPolicy key, int value) {
            this.enumMap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEnumMap(Map.Entry<RetentionPolicy, ? extends Integer> entry) {
            this.enumMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enumMap(Map<RetentionPolicy, ? extends Integer> entries) {
            this.enumMap = ImmutableMap.builder();
            return this.putAllEnumMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllEnumMap(Map<RetentionPolicy, ? extends Integer> entries) {
            this.enumMap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSortedMap(RetentionPolicy key, int value) {
            this.sortedMap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSortedMap(Map.Entry<? extends RetentionPolicy, ? extends Integer> entry) {
            this.sortedMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortedMap(Map<? extends RetentionPolicy, ? extends Integer> entries) {
            this.sortedMap = ImmutableSortedMap.reverseOrder();
            return this.putAllSortedMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSortedMap(Map<? extends RetentionPolicy, ? extends Integer> entries) {
            this.sortedMap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMultimap(String key, int ... values) {
            this.multimap.putAll((Object)key, (Iterable)Ints.asList((int[])values));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllMultimap(String key, Iterable<Integer> values) {
            this.multimap.putAll((Object)key, values);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMultimap(String key, int value) {
            this.multimap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMultimap(Map.Entry<String, ? extends Integer> entry) {
            this.multimap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder multimap(Multimap<String, ? extends Integer> entries) {
            this.multimap = ImmutableMultimap.builder();
            return this.putAllMultimap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMultimap(Multimap<String, ? extends Integer> entries) {
            this.multimap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSetMultimap(String key, int ... values) {
            this.setMultimap.putAll((Object)key, (Iterable)Ints.asList((int[])values));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllSetMultimap(String key, Iterable<Integer> values) {
            this.setMultimap.putAll((Object)key, values);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSetMultimap(String key, int value) {
            this.setMultimap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSetMultimap(Map.Entry<String, ? extends Integer> entry) {
            this.setMultimap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setMultimap(Multimap<String, ? extends Integer> entries) {
            this.setMultimap = ImmutableSetMultimap.builder();
            return this.putAllSetMultimap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSetMultimap(Multimap<String, ? extends Integer> entries) {
            this.setMultimap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putListMultimap(String key, int ... values) {
            this.listMultimap.putAll((Object)key, (Iterable)Ints.asList((int[])values));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllListMultimap(String key, Iterable<Integer> values) {
            this.listMultimap.putAll((Object)key, values);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putListMultimap(String key, int value) {
            this.listMultimap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putListMultimap(Map.Entry<String, ? extends Integer> entry) {
            this.listMultimap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder listMultimap(Multimap<String, ? extends Integer> entries) {
            this.listMultimap = ImmutableListMultimap.builder();
            return this.putAllListMultimap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllListMultimap(Multimap<String, ? extends Integer> entries) {
            this.listMultimap.putAll(entries);
            return this;
        }

        public ImmutableUseImmutableCollections build() {
            return new ImmutableUseImmutableCollections(this.list.build(), this.set.build(), Sets.immutableEnumSet((Iterable)this.enumSet.build()), this.sortedSet.build(), this.multiset.build(), this.map.build(), Maps.immutableEnumMap((Map)this.enumMap.build()), this.sortedMap.build(), this.multimap.build(), this.setMultimap.build(), this.listMultimap.build());
        }
    }
}

