/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SillyLazy;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SillyLazy", generator="Immutables")
@Immutable
public final class ImmutableSillyLazy
extends SillyLazy {
    private final AtomicInteger counter;
    private volatile transient long lazyInitBitmap;
    private static final long VAL1_LAZY_INIT_BIT = 1L;
    private transient int val1;
    private static final long VAL2_LAZY_INIT_BIT = 2L;
    private transient int val2;

    private ImmutableSillyLazy(AtomicInteger counter) {
        this.counter = Objects.requireNonNull(counter, "counter");
    }

    private ImmutableSillyLazy(ImmutableSillyLazy original, AtomicInteger counter) {
        this.counter = counter;
    }

    @Override
    public AtomicInteger counter() {
        return this.counter;
    }

    public final ImmutableSillyLazy withCounter(AtomicInteger value) {
        AtomicInteger newValue = Objects.requireNonNull(value, "counter");
        if (this.counter.equals(newValue)) {
            return this;
        }
        return new ImmutableSillyLazy(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSillyLazy && this.equalTo(0, (ImmutableSillyLazy)another);
    }

    private boolean equalTo(int synthetic, ImmutableSillyLazy another) {
        return this.counter.equals(another.counter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.counter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SillyLazy").omitNullValues().add("counter", (Object)this.counter).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int val1() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableSillyLazy immutableSillyLazy = this;
            synchronized (immutableSillyLazy) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.val1 = super.val1();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.val1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int val2() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableSillyLazy immutableSillyLazy = this;
            synchronized (immutableSillyLazy) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.val2 = super.val2();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.val2;
    }

    public static ImmutableSillyLazy of(AtomicInteger counter) {
        return new ImmutableSillyLazy(counter);
    }

    public static ImmutableSillyLazy copyOf(SillyLazy instance) {
        if (instance instanceof ImmutableSillyLazy) {
            return (ImmutableSillyLazy)instance;
        }
        return ImmutableSillyLazy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SillyLazy", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COUNTER = 1L;
        private long initBits = 1L;
        @Nullable
        private AtomicInteger counter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SillyLazy instance) {
            Objects.requireNonNull(instance, "instance");
            this.counter(instance.counter());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder counter(AtomicInteger counter) {
            this.counter = Objects.requireNonNull(counter, "counter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSillyLazy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSillyLazy(null, this.counter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("counter");
            }
            return "Cannot build SillyLazy, some of required attributes are not set " + attributes;
        }
    }
}

