/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.Redacted;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Redacted.RedactedMaskJdkOnlyOpt", generator="Immutables")
@Immutable
public final class ImmutableRedactedMaskJdkOnlyOpt
implements Redacted.RedactedMaskJdkOnlyOpt {
    private final int code;
    @Nullable
    private final String opt;

    private ImmutableRedactedMaskJdkOnlyOpt(int code, @Nullable String opt) {
        this.code = code;
        this.opt = opt;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public Optional<String> opt() {
        return Optional.ofNullable(this.opt);
    }

    public final ImmutableRedactedMaskJdkOnlyOpt withCode(int value) {
        if (this.code == value) {
            return this;
        }
        return new ImmutableRedactedMaskJdkOnlyOpt(value, this.opt);
    }

    public final ImmutableRedactedMaskJdkOnlyOpt withOpt(String value) {
        String newValue = Objects.requireNonNull(value, "opt");
        if (Objects.equals(this.opt, newValue)) {
            return this;
        }
        return new ImmutableRedactedMaskJdkOnlyOpt(this.code, newValue);
    }

    public final ImmutableRedactedMaskJdkOnlyOpt withOpt(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.opt, value)) {
            return this;
        }
        return new ImmutableRedactedMaskJdkOnlyOpt(this.code, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRedactedMaskJdkOnlyOpt && this.equalTo(0, (ImmutableRedactedMaskJdkOnlyOpt)another);
    }

    private boolean equalTo(int synthetic, ImmutableRedactedMaskJdkOnlyOpt another) {
        return this.code == another.code && Objects.equals(this.opt, another.opt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.code;
        h += (h << 5) + Objects.hashCode(this.opt);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RedactedMaskJdkOnlyOpt{");
        builder.append("code=").append("????");
        if (this.opt != null) {
            builder.append(", ");
            builder.append("opt=").append(this.opt);
        }
        return builder.append("}").toString();
    }

    public static ImmutableRedactedMaskJdkOnlyOpt copyOf(Redacted.RedactedMaskJdkOnlyOpt instance) {
        if (instance instanceof ImmutableRedactedMaskJdkOnlyOpt) {
            return (ImmutableRedactedMaskJdkOnlyOpt)instance;
        }
        return ImmutableRedactedMaskJdkOnlyOpt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Redacted.RedactedMaskJdkOnlyOpt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private long initBits = 1L;
        private int code;
        @Nullable
        private String opt;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Redacted.RedactedMaskJdkOnlyOpt instance) {
            Objects.requireNonNull(instance, "instance");
            this.code(instance.code());
            Optional<String> optOptional = instance.opt();
            if (optOptional.isPresent()) {
                this.opt(optOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder code(int code) {
            this.code = code;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder opt(String opt) {
            this.opt = Objects.requireNonNull(opt, "opt");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder opt(Optional<String> opt) {
            this.opt = opt.orElse(null);
            return this;
        }

        public ImmutableRedactedMaskJdkOnlyOpt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRedactedMaskJdkOnlyOpt(this.code, this.opt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            return "Cannot build RedactedMaskJdkOnlyOpt, some of required attributes are not set " + attributes;
        }
    }
}

