/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.NewValueNamedWithCollission;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NewValueNamedWithCollission", generator="Immutables")
@Immutable
public final class ImmutableNewValueNamedWithCollission
implements NewValueNamedWithCollission {
    private final String newValue;
    private final String oldValue;

    private ImmutableNewValueNamedWithCollission(String newValue, String oldValue) {
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    @Override
    public String getNewValue() {
        return this.newValue;
    }

    @Override
    public String getOldValue() {
        return this.oldValue;
    }

    public final ImmutableNewValueNamedWithCollission withNewValue(String value) {
        String newValue = Objects.requireNonNull(value, "newValue");
        if (this.newValue.equals(newValue)) {
            return this;
        }
        return new ImmutableNewValueNamedWithCollission(newValue, this.oldValue);
    }

    public final ImmutableNewValueNamedWithCollission withOldValue(String value) {
        String newValue = Objects.requireNonNull(value, "oldValue");
        if (this.oldValue.equals(newValue)) {
            return this;
        }
        return new ImmutableNewValueNamedWithCollission(this.newValue, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNewValueNamedWithCollission && this.equalTo(0, (ImmutableNewValueNamedWithCollission)another);
    }

    private boolean equalTo(int synthetic, ImmutableNewValueNamedWithCollission another) {
        return this.newValue.equals(another.newValue) && this.oldValue.equals(another.oldValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.newValue.hashCode();
        h += (h << 5) + this.oldValue.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NewValueNamedWithCollission").omitNullValues().add("newValue", (Object)this.newValue).add("oldValue", (Object)this.oldValue).toString();
    }

    public static ImmutableNewValueNamedWithCollission copyOf(NewValueNamedWithCollission instance) {
        if (instance instanceof ImmutableNewValueNamedWithCollission) {
            return (ImmutableNewValueNamedWithCollission)instance;
        }
        return ImmutableNewValueNamedWithCollission.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NewValueNamedWithCollission", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NEW_VALUE = 1L;
        private static final long INIT_BIT_OLD_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String newValue;
        @Nullable
        private String oldValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NewValueNamedWithCollission instance) {
            Objects.requireNonNull(instance, "instance");
            this.newValue(instance.getNewValue());
            this.oldValue(instance.getOldValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder newValue(String newValue) {
            this.newValue = Objects.requireNonNull(newValue, "newValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oldValue(String oldValue) {
            this.oldValue = Objects.requireNonNull(oldValue, "oldValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableNewValueNamedWithCollission build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNewValueNamedWithCollission(this.newValue, this.oldValue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("newValue");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("oldValue");
            }
            return "Cannot build NewValueNamedWithCollission, some of required attributes are not set " + attributes;
        }
    }
}

