/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.IfaceValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IfaceValue", generator="Immutables")
@Immutable
public final class ImmutableIfaceValue
implements IfaceValue {
    private final int number;
    private final ImmutableList<String> auxiliary;
    private final transient int get;

    private ImmutableIfaceValue(int number) {
        this.number = number;
        this.auxiliary = ImmutableList.of();
        this.get = IfaceValue.super.get();
    }

    private ImmutableIfaceValue(int number, ImmutableList<String> auxiliary) {
        this.number = number;
        this.auxiliary = auxiliary;
        this.get = IfaceValue.super.get();
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public ImmutableList<String> auxiliary() {
        return this.auxiliary;
    }

    @Override
    public int get() {
        return this.get;
    }

    public final ImmutableIfaceValue withNumber(int value) {
        if (this.number == value) {
            return this;
        }
        return new ImmutableIfaceValue(value, this.auxiliary);
    }

    public final ImmutableIfaceValue withAuxiliary(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableIfaceValue(this.number, (ImmutableList<String>)newValue);
    }

    public final ImmutableIfaceValue withAuxiliary(Iterable<String> elements) {
        if (this.auxiliary == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableIfaceValue(this.number, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIfaceValue && this.equalTo(0, (ImmutableIfaceValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableIfaceValue another) {
        return this.number == another.number;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.number;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IfaceValue").omitNullValues().add("number", this.number).toString();
    }

    public static ImmutableIfaceValue of(int number) {
        return new ImmutableIfaceValue(number);
    }

    public static ImmutableIfaceValue copyOf(IfaceValue instance) {
        if (instance instanceof ImmutableIfaceValue) {
            return (ImmutableIfaceValue)instance;
        }
        return ImmutableIfaceValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IfaceValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NUMBER = 1L;
        private long initBits = 1L;
        private int number;
        private ImmutableList.Builder<String> auxiliary = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IfaceValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.number(instance.getNumber());
            this.addAllAuxiliary(instance.auxiliary());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder number(int number) {
            this.number = number;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAuxiliary(String element) {
            this.auxiliary.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAuxiliary(String ... elements) {
            this.auxiliary.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auxiliary(Iterable<String> elements) {
            this.auxiliary = ImmutableList.builder();
            return this.addAllAuxiliary(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAuxiliary(Iterable<String> elements) {
            this.auxiliary.addAll(elements);
            return this;
        }

        public ImmutableIfaceValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIfaceValue(this.number, this.auxiliary.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("number");
            }
            return "Cannot build IfaceValue, some of required attributes are not set " + attributes;
        }
    }
}

