/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.EntityWithMap;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EntityWithMap", generator="Immutables")
@Immutable
public final class ImmutableEntityWithMap
implements EntityWithMap {
    private final Map<String, String> properties;

    private ImmutableEntityWithMap(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public final ImmutableEntityWithMap withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableEntityWithMap.createUnmodifiableMap(true, false, entries);
        return new ImmutableEntityWithMap(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntityWithMap && this.equalTo(0, (ImmutableEntityWithMap)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntityWithMap another) {
        return this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "EntityWithMap{properties=" + this.properties + "}";
    }

    public static ImmutableEntityWithMap copyOf(EntityWithMap instance) {
        if (instance instanceof ImmutableEntityWithMap) {
            return (ImmutableEntityWithMap)instance;
        }
        return ImmutableEntityWithMap.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="EntityWithMap", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EntityWithMap instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllProperties(instance.properties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, String value) {
            this.properties.put(Objects.requireNonNull(key, "properties key"), value == null ? Objects.requireNonNull(value, "properties value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.properties.put(Objects.requireNonNull(k, "properties key"), v == null ? Objects.requireNonNull(v, "properties value for key: " + k) : v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties.clear();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.properties.put(Objects.requireNonNull(k, "properties key"), v == null ? Objects.requireNonNull(v, "properties value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableEntityWithMap build() {
            return new ImmutableEntityWithMap(ImmutableEntityWithMap.createUnmodifiableMap(false, false, this.properties));
        }
    }
}

