/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.DefaultDerivedInit;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DefaultDerivedInit", generator="Immutables")
@Immutable
public final class ImmutableDefaultDerivedInit
extends DefaultDerivedInit {
    private final transient String index;
    private final String uuid;
    private final String title;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDefaultDerivedInit(String uuid, String title) {
        this.initShim.uuid(Objects.requireNonNull(uuid, "uuid"));
        this.title = Objects.requireNonNull(title, "title");
        this.index = this.initShim.index();
        this.uuid = this.initShim.uuid();
        this.initShim = null;
    }

    private ImmutableDefaultDerivedInit(Builder builder) {
        this.title = builder.title;
        if (builder.uuid != null) {
            this.initShim.uuid(builder.uuid);
        }
        this.index = this.initShim.index();
        this.uuid = this.initShim.uuid();
        this.initShim = null;
    }

    private ImmutableDefaultDerivedInit(ImmutableDefaultDerivedInit original, String uuid, String title) {
        this.initShim.uuid(uuid);
        this.title = title;
        this.index = this.initShim.index();
        this.uuid = this.initShim.uuid();
        this.initShim = null;
    }

    @Override
    public String index() {
        InitShim shim = this.initShim;
        return shim != null ? shim.index() : this.index;
    }

    @Override
    public String uuid() {
        InitShim shim = this.initShim;
        return shim != null ? shim.uuid() : this.uuid;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutableDefaultDerivedInit withUuid(String value) {
        String newValue = Objects.requireNonNull(value, "uuid");
        if (this.uuid.equals(newValue)) {
            return this;
        }
        return new ImmutableDefaultDerivedInit(this, newValue, this.title);
    }

    public final ImmutableDefaultDerivedInit withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableDefaultDerivedInit(this, this.uuid, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultDerivedInit && this.equalTo(0, (ImmutableDefaultDerivedInit)another);
    }

    private boolean equalTo(int synthetic, ImmutableDefaultDerivedInit another) {
        return this.index.equals(another.index) && this.uuid.equals(another.uuid) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.index.hashCode();
        h += (h << 5) + this.uuid.hashCode();
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DefaultDerivedInit").omitNullValues().add("index", (Object)this.index).add("uuid", (Object)this.uuid).add("title", (Object)this.title).toString();
    }

    public static ImmutableDefaultDerivedInit of(String uuid, String title) {
        return new ImmutableDefaultDerivedInit(uuid, title);
    }

    public static ImmutableDefaultDerivedInit copyOf(DefaultDerivedInit instance) {
        if (instance instanceof ImmutableDefaultDerivedInit) {
            return (ImmutableDefaultDerivedInit)instance;
        }
        return ImmutableDefaultDerivedInit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DefaultDerivedInit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private long initBits = 1L;
        @Nullable
        private String uuid;
        @Nullable
        private String title;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DefaultDerivedInit instance) {
            Objects.requireNonNull(instance, "instance");
            this.uuid(instance.uuid());
            this.title(instance.title());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uuid(String uuid) {
            this.uuid = Objects.requireNonNull(uuid, "uuid");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDefaultDerivedInit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDefaultDerivedInit(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build DefaultDerivedInit, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="DefaultDerivedInit", generator="Immutables")
    private final class InitShim {
        private byte indexBuildStage = 0;
        private String index;
        private byte uuidBuildStage = 0;
        private String uuid;

        private InitShim() {
        }

        String index() {
            if (this.indexBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexBuildStage == 0) {
                this.indexBuildStage = (byte)-1;
                this.index = Objects.requireNonNull(ImmutableDefaultDerivedInit.super.index(), "index");
                this.indexBuildStage = 1;
            }
            return this.index;
        }

        String uuid() {
            if (this.uuidBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uuidBuildStage == 0) {
                this.uuidBuildStage = (byte)-1;
                this.uuid = Objects.requireNonNull(ImmutableDefaultDerivedInit.super.uuid(), "uuid");
                this.uuidBuildStage = 1;
            }
            return this.uuid;
        }

        void uuid(String uuid) {
            this.uuid = uuid;
            this.uuidBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.indexBuildStage == -1) {
                attributes.add("index");
            }
            if (this.uuidBuildStage == -1) {
                attributes.add("uuid");
            }
            return "Cannot build DefaultDerivedInit, attribute initializers form cycle " + attributes;
        }
    }
}

