/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.ImmutableSillyMapHolder;
import org.immutables.fixture.SillyMapHolder;
import org.immutables.fixture.SillyMapTup;
import org.immutables.fixture.SillyValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture", generator="Gsons")
public final class GsonAdaptersSillyMapHolder
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SillyMapHolderTypeAdapter.adapts(type)) {
            return new SillyMapHolderTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersSillyMapHolder(SillyMapHolder)";
    }

    @Generated(from="SillyMapHolder", generator="Gsons")
    private static class SillyMapHolderTypeAdapter
    extends TypeAdapter<SillyMapHolder> {
        public final SillyValue holder1TypeSample = null;
        public final Integer holder1SecondaryTypeSample = null;
        public final Integer holder2TypeSample = null;
        public final SillyMapTup holder3SecondaryTypeSample = null;
        public final RetentionPolicy zzTypeSample = null;
        private final TypeAdapter<SillyValue> holder1TypeAdapter;
        private final TypeAdapter<Integer> holder1SecondaryTypeAdapter;
        private final TypeAdapter<Integer> holder2TypeAdapter;
        private final TypeAdapter<SillyMapTup> holder3SecondaryTypeAdapter;
        private final TypeAdapter<RetentionPolicy> zzTypeAdapter;

        SillyMapHolderTypeAdapter(Gson gson) {
            this.holder1TypeAdapter = gson.getAdapter(SillyValue.class);
            this.holder1SecondaryTypeAdapter = gson.getAdapter(Integer.class);
            this.holder2TypeAdapter = gson.getAdapter(Integer.class);
            this.holder3SecondaryTypeAdapter = gson.getAdapter(SillyMapTup.class);
            this.zzTypeAdapter = gson.getAdapter(RetentionPolicy.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return SillyMapHolder.class == type.getRawType() || ImmutableSillyMapHolder.class == type.getRawType();
        }

        public void write(JsonWriter out, SillyMapHolder value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSillyMapHolder(out, value);
            }
        }

        public SillyMapHolder read(JsonReader in) throws IOException {
            return this.readSillyMapHolder(in);
        }

        private void writeSillyMapHolder(JsonWriter out, SillyMapHolder instance) throws IOException {
            out.beginObject();
            Map<SillyValue, Integer> holder1Mapping = instance.holder1();
            out.name("holder1");
            out.beginObject();
            for (Map.Entry<SillyValue, Integer> entry : holder1Mapping.entrySet()) {
                String string = this.holder1TypeAdapter.toJsonTree((Object)entry.getKey()).getAsString();
                out.name(string);
                int n = entry.getValue();
                this.holder1SecondaryTypeAdapter.write(out, (Object)n);
            }
            out.endObject();
            Map<Integer, String> holder2Mapping = instance.holder2();
            out.name("holder2");
            out.beginObject();
            for (Map.Entry<Integer, String> entry : holder2Mapping.entrySet()) {
                String string = String.valueOf(entry.getKey());
                out.name(string);
                String value = entry.getValue();
                out.value(value);
            }
            out.endObject();
            Map<String, SillyMapTup> map = instance.holder3();
            out.name("holder3");
            out.beginObject();
            for (Map.Entry<String, SillyMapTup> entry : map.entrySet()) {
                String key = entry.getKey();
                out.name(key);
                SillyMapTup value = entry.getValue();
                this.holder3SecondaryTypeAdapter.write(out, (Object)value);
            }
            out.endObject();
            Set<RetentionPolicy> set = instance.zz();
            out.name("zz");
            out.beginArray();
            for (RetentionPolicy e : set) {
                this.zzTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.endObject();
        }

        private SillyMapHolder readSillyMapHolder(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableSillyMapHolder.Builder builder = ImmutableSillyMapHolder.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableSillyMapHolder.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'h': {
                    if ("holder1".equals(attributeName)) {
                        this.readInHolder1(in, builder);
                        return;
                    }
                    if ("holder2".equals(attributeName)) {
                        this.readInHolder2(in, builder);
                        return;
                    }
                    if (!"holder3".equals(attributeName)) break;
                    this.readInHolder3(in, builder);
                    return;
                }
                case 'z': {
                    if (!"zz".equals(attributeName)) break;
                    this.readInZz(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInHolder1(JsonReader in, ImmutableSillyMapHolder.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey = in.nextName();
                    SillyValue key = (SillyValue)((Object)this.holder1TypeAdapter.fromJsonTree((JsonElement)new JsonPrimitive(rawKey)));
                    Integer value = (Integer)this.holder1SecondaryTypeAdapter.read(in);
                    builder.putHolder1(key, value);
                }
                in.endObject();
            }
        }

        private void readInHolder2(JsonReader in, ImmutableSillyMapHolder.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey = in.nextName();
                    int key = Integer.parseInt(rawKey);
                    String value = in.nextString();
                    builder.putHolder2(key, value);
                }
                in.endObject();
            }
        }

        private void readInHolder3(JsonReader in, ImmutableSillyMapHolder.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    SillyMapTup value = (SillyMapTup)this.holder3SecondaryTypeAdapter.read(in);
                    builder.putHolder3(key, value);
                }
                in.endObject();
            }
        }

        private void readInZz(JsonReader in, ImmutableSillyMapHolder.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    RetentionPolicy value = (RetentionPolicy)((Object)this.zzTypeAdapter.read(in));
                    builder.addZz(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                RetentionPolicy value = (RetentionPolicy)((Object)this.zzTypeAdapter.read(in));
                builder.addZz(value);
            }
        }
    }
}

