/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.HasTypeAnnotation;
import org.immutables.fixture.ImmutableHasTypeAnnotation;
import org.immutables.fixture.TypeA;
import org.immutables.fixture.TypeB;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture", generator="Gsons")
public final class GsonAdaptersHasTypeAnnotation
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (HasTypeAnnotationTypeAdapter.adapts(type)) {
            return new HasTypeAnnotationTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersHasTypeAnnotation(HasTypeAnnotation)";
    }

    @Generated(from="HasTypeAnnotation", generator="Gsons")
    private static class HasTypeAnnotationTypeAdapter
    extends TypeAdapter<HasTypeAnnotation> {
        public final @TypeA @TypeB String strTypeSample;
        private final TypeAdapter<@TypeA @TypeB String> strTypeAdapter;
        private final TypeAdapter<byte[]> bteTypeAdapter;

        HasTypeAnnotationTypeAdapter(Gson gson) {
            this.strTypeSample = null;
            this.strTypeAdapter = gson.getAdapter(String.class);
            this.bteTypeAdapter = gson.getAdapter(byte[].class);
        }

        static boolean adapts(TypeToken<?> type) {
            return HasTypeAnnotation.class == type.getRawType() || ImmutableHasTypeAnnotation.class == type.getRawType();
        }

        public void write(JsonWriter out, HasTypeAnnotation value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeHasTypeAnnotation(out, value);
            }
        }

        public HasTypeAnnotation read(JsonReader in) throws IOException {
            return this.readHasTypeAnnotation(in);
        }

        private void writeHasTypeAnnotation(JsonWriter out, HasTypeAnnotation instance) throws IOException {
            out.beginObject();
            @TypeA @TypeB String strValue = instance.str();
            if (strValue != null) {
                out.name("str");
                this.strTypeAdapter.write(out, (Object)strValue);
            } else if (out.getSerializeNulls()) {
                out.name("str");
                out.nullValue();
            }
            byte[] bteValue = instance.bte();
            if (bteValue != null) {
                out.name("bte");
                this.bteTypeAdapter.write(out, (Object)bteValue);
            } else if (out.getSerializeNulls()) {
                out.name("bte");
                out.nullValue();
            }
            @TypeA @TypeB Map<String, String> mapMapping = instance.map();
            if (mapMapping != null) {
                out.name("map");
                out.beginObject();
                for (Map.Entry<String, String> e : mapMapping.entrySet()) {
                    String key = e.getKey();
                    out.name(key);
                    String value = e.getValue();
                    out.value(value);
                }
                out.endObject();
            } else if (out.getSerializeNulls()) {
                out.name("map");
                out.nullValue();
            }
            out.endObject();
        }

        private HasTypeAnnotation readHasTypeAnnotation(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableHasTypeAnnotation.Builder builder = ImmutableHasTypeAnnotation.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableHasTypeAnnotation.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 's': {
                    if (!"str".equals(attributeName)) break;
                    this.readInStr(in, builder);
                    return;
                }
                case 'b': {
                    if (!"bte".equals(attributeName)) break;
                    this.readInBte(in, builder);
                    return;
                }
                case 'm': {
                    if (!"map".equals(attributeName)) break;
                    this.readInMap(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInStr(JsonReader in, ImmutableHasTypeAnnotation.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.str(in.nextString());
            }
        }

        private void readInBte(JsonReader in, ImmutableHasTypeAnnotation.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                byte[] value = (byte[])this.bteTypeAdapter.read(in);
                builder.bte(value);
            }
        }

        private void readInMap(JsonReader in, ImmutableHasTypeAnnotation.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                boolean empty = true;
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putMap(key, value);
                    empty = false;
                }
                if (empty) {
                    builder.putAllMap(Collections.emptyMap());
                }
                in.endObject();
            }
        }
    }
}

