package org.immutables.fixture.with;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@Generated(from = "WithMapUnary", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public interface WithWithMapUnary {

  /**
   * Copy the current immutable object by setting a value for the {@link WithMapUnary#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  WithMapUnary withA(int value);

  /**
   * Copy the current immutable object by transforming value of {@link WithMapUnary#a() a}
   * using the provided {@code UnaryOperator}. It always returns a new copy.
   * @param operator Unary operator to transform value of a
   * @return A modified copy of {@code this} object
   */
  WithMapUnary mapA(UnaryOperator<Integer> operator);

  /**
   * Copy the current immutable object by setting a value for the {@link WithMapUnary#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  WithMapUnary withB(String value);

  /**
   * Copy the current immutable object by transforming value of {@link WithMapUnary#b() b}
   * using the provided {@code UnaryOperator}. It always returns a new copy.
   * @param operator Unary operator to transform value of b
   * @return A modified copy of {@code this} object
   */
  WithMapUnary mapB(UnaryOperator<String> operator);

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WithMapUnary#o() o} attribute.
   * @param value The value for o
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withO(String value);

  /**
   * Copy the current immutable object by setting an optional value for the {@link WithMapUnary#o() o} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for o
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withO(Optional<String> optional);

  /**
   * Copy the current immutable object by transforming optional value of {@link WithMapUnary#o() o}
   * using the provided {@code UnaryOperator}.
   * It always returns a new copy if optional is present, otherwise {@code this} is returned.
   * @param operator Unary operator to transform optional value of o
   * @return A modified copy of {@code this} object
   */
  WithMapUnary mapO(UnaryOperator<String> operator);

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithMapUnary#l() l}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withL(String... elements);

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithMapUnary#l() l}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of l elements to set
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withL(Iterable<String> elements);

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithMapUnary#l() l},
   * transformed by passing each element to the provided {@code UnaryOperator}.
   * It always returns a new copy unless collection is empty.
   * @param operator Unary operator to transform each element of l
   * @return A modified copy of {@code this} object
   */
  WithMapUnary mapL(UnaryOperator<String> operator);

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WithMapUnary#i() i} attribute.
   * @param value The value for i
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withI(int value);

  /**
   * Copy the current immutable object by setting an optional value for the {@link WithMapUnary#i() i} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for i
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withI(OptionalInt optional);

  /**
   * Copy the current immutable object by transforming optional value of {@link WithMapUnary#i() i}
   * using the provided {@code UnaryOperator}.
   * It always returns a new copy if optional is present, otherwise {@code this} is returned.
   * @param operator Unary operator to transform optional value of i
   * @return A modified copy of {@code this} object
   */
  WithMapUnary mapI(UnaryOperator<Integer> operator);

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WithMapUnary#d() d} attribute.
   * @param value The value for d
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withD(double value);

  /**
   * Copy the current immutable object by setting an optional value for the {@link WithMapUnary#d() d} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for d
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withD(OptionalDouble optional);

  /**
   * Copy the current immutable object by transforming optional value of {@link WithMapUnary#d() d}
   * using the provided {@code UnaryOperator}.
   * It always returns a new copy if optional is present, otherwise {@code this} is returned.
   * @param operator Unary operator to transform optional value of d
   * @return A modified copy of {@code this} object
   */
  WithMapUnary mapD(UnaryOperator<Double> operator);

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WithMapUnary#oi() oi} attribute.
   * @param value The value for oi
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withOi(int value);

  /**
   * Copy the current immutable object by setting an optional value for the {@link WithMapUnary#oi() oi} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for oi
   * @return A modified copy of {@code this} object
   */
  WithMapUnary withOi(com.google.common.base.Optional<Integer> optional);

  /**
   * Copy the current immutable object by transforming optional value of {@link WithMapUnary#oi() oi}
   * using the provided {@code UnaryOperator}.
   * It always returns a new copy if optional is present, otherwise {@code this} is returned.
   * @param operator Unary operator to transform optional value of oi
   * @return A modified copy of {@code this} object
   */
  WithMapUnary mapOi(UnaryOperator<Integer> operator);
}
