package org.immutables.fixture.with;

import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@Generated(from = "Copied", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
interface WithCopied {

  /**
   * Copy the current immutable object by setting a value for the {@link Copied#attr() attr} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attr
   * @return A modified copy of the {@code this} object
   */
  Copied withAttr(int value);

  /**
   * Copy the current immutable object by setting a value for the {@link Copied#voids() voids} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for voids (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  Copied withVoids(@Nullable Void value);

  /**
   * Copy the current immutable object with elements that replace the content of {@link Copied#arr() arr}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for arr
   * @return A modified copy of {@code this} object
   */
  Copied withArr(String... elements);

  /**
   * Copy the current immutable object by replacing the {@link Copied#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  Copied withMap(Map<String, ? extends Integer> entries);

  /**
   * Copy the current immutable object with elements that replace the content of {@link Copied#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  Copied withList(boolean... elements);

  /**
   * Copy the current immutable object with elements that replace the content of {@link Copied#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  Copied withList(Iterable<Boolean> elements);
}
