package org.immutables.fixture.with;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WithMapUnary}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new WithMapUnary.Builder()}.
 */
@Generated(from = "WithMapUnary", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWithMapUnary implements WithMapUnary {
  private final int a;
  private final String b;
  private final @Nullable String o;
  private final ImmutableList<String> l;
  private final @Nullable Integer i;
  private final @Nullable Double d;
  private final Optional<Integer> oi;

  private ImmutableWithMapUnary(
      int a,
      String b,
      @Nullable String o,
      ImmutableList<String> l,
      @Nullable Integer i,
      @Nullable Double d,
      Optional<Integer> oi) {
    this.a = a;
    this.b = b;
    this.o = o;
    this.l = l;
    this.i = i;
    this.d = d;
    this.oi = oi;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public String b() {
    return b;
  }

  /**
   * @return The value of the {@code o} attribute
   */
  @Override
  public java.util.Optional<String> o() {
    return java.util.Optional.ofNullable(o);
  }

  /**
   * @return The value of the {@code l} attribute
   */
  @Override
  public ImmutableList<String> l() {
    return l;
  }

  /**
   * @return The value of the {@code i} attribute
   */
  @Override
  public OptionalInt i() {
    return i != null
        ? OptionalInt.of(i)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  public OptionalDouble d() {
    return d != null
        ? OptionalDouble.of(d)
        : OptionalDouble.empty();
  }

  /**
   * @return The value of the {@code oi} attribute
   */
  @Override
  public Optional<Integer> oi() {
    return oi;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WithMapUnary#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithMapUnary withA(int value) {
    if (this.a == value) return this;
    return new ImmutableWithMapUnary(value, this.b, this.o, this.l, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by transforming value of {@link WithMapUnary#a() a}
   * using the provided {@code UnaryOperator}. It always returns a new copy.
   * @param operator Unary operator to transform value of a
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary mapA(UnaryOperator<Integer> operator) {
    int value = operator.apply(this.a);
    return new ImmutableWithMapUnary(value, this.b, this.o, this.l, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WithMapUnary#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithMapUnary withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableWithMapUnary(this.a, newValue, this.o, this.l, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by transforming value of {@link WithMapUnary#b() b}
   * using the provided {@code UnaryOperator}. It always returns a new copy.
   * @param operator Unary operator to transform value of b
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary mapB(UnaryOperator<String> operator) {
    String value = operator.apply(this.b);
    return new ImmutableWithMapUnary(this.a, value, this.o, this.l, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WithMapUnary#o() o} attribute.
   * @param value The value for o
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withO(String value) {
    String newValue = Objects.requireNonNull(value, "o");
    if (Objects.equals(this.o, newValue)) return this;
    return new ImmutableWithMapUnary(this.a, this.b, newValue, this.l, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WithMapUnary#o() o} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for o
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withO(java.util.Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.o, value)) return this;
    return new ImmutableWithMapUnary(this.a, this.b, value, this.l, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by transforming optional value of {@link WithMapUnary#o() o}
   * using the provided {@code UnaryOperator}.
   * It always returns a new copy if optional is present, otherwise {@code this} is returned.
   * @param operator Unary operator to transform optional value of o
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary mapO(UnaryOperator<String> operator) {
    if (this.o == null) return this;
    @Nullable String value = operator.apply(this.o);
    return new ImmutableWithMapUnary(this.a, this.b, value, this.l, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithMapUnary#l() l}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withL(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWithMapUnary(this.a, this.b, this.o, newValue, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithMapUnary#l() l}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of l elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withL(Iterable<String> elements) {
    if (this.l == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWithMapUnary(this.a, this.b, this.o, newValue, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithMapUnary#l() l},
   * transformed by passing each element to the provided {@code UnaryOperator}.
   * It always returns a new copy unless collection is empty.
   * @param operator Unary operator to transform each element of l
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary mapL(UnaryOperator<String> operator) {
    if (this.l.isEmpty()) return this;
    List<String> elements = this.l.stream().map(operator)
        .collect(Collectors.toList());
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWithMapUnary(this.a, this.b, this.o, newValue, this.i, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WithMapUnary#i() i} attribute.
   * @param value The value for i
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withI(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.i, newValue)) return this;
    return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, newValue, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WithMapUnary#i() i} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for i
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withI(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.i, value)) return this;
    return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, value, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by transforming optional value of {@link WithMapUnary#i() i}
   * using the provided {@code UnaryOperator}.
   * It always returns a new copy if optional is present, otherwise {@code this} is returned.
   * @param operator Unary operator to transform optional value of i
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary mapI(UnaryOperator<Integer> operator) {
    if (this.i == null) return this;
    @Nullable Integer value = operator.apply(this.i);
    return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, value, this.d, this.oi);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WithMapUnary#d() d} attribute.
   * @param value The value for d
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withD(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.d, newValue)) return this;
    return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, newValue, this.oi);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WithMapUnary#d() d} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for d
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withD(OptionalDouble optional) {
    @Nullable Double value = optional.isPresent() ? optional.getAsDouble() : null;
    if (Objects.equals(this.d, value)) return this;
    return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, value, this.oi);
  }

  /**
   * Copy the current immutable object by transforming optional value of {@link WithMapUnary#d() d}
   * using the provided {@code UnaryOperator}.
   * It always returns a new copy if optional is present, otherwise {@code this} is returned.
   * @param operator Unary operator to transform optional value of d
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary mapD(UnaryOperator<Double> operator) {
    if (this.d == null) return this;
    @Nullable Double value = operator.apply(this.d);
    return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, value, this.oi);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WithMapUnary#oi() oi} attribute.
   * @param value The value for oi
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withOi(int value) {
    Optional<Integer> newValue = Optional.of(value);
    if (this.oi.equals(newValue)) return this;
    return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, this.d, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WithMapUnary#oi() oi} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for oi
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary withOi(Optional<Integer> optional) {
    Optional<Integer> value = optional;
    if (this.oi.equals(value)) return this;
    return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, this.d, value);
  }

  /**
   * Copy the current immutable object by transforming optional value of {@link WithMapUnary#oi() oi}
   * using the provided {@code UnaryOperator}.
   * It always returns a new copy if optional is present, otherwise {@code this} is returned.
   * @param operator Unary operator to transform optional value of oi
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithMapUnary mapOi(UnaryOperator<Integer> operator) {
    if (!this.oi.isPresent()) return this;
    Optional<Integer> value = Optional.of(operator.apply(this.oi.get()));
    return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, this.d, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWithMapUnary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWithMapUnary
        && equalTo(0, (ImmutableWithMapUnary) another);
  }

  private boolean equalTo(int synthetic, ImmutableWithMapUnary another) {
    return a == another.a
        && b.equals(another.b)
        && Objects.equals(o, another.o)
        && l.equals(another.l)
        && Objects.equals(i, another.i)
        && Objects.equals(d, another.d)
        && oi.equals(another.oi);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code o}, {@code l}, {@code i}, {@code d}, {@code oi}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + Objects.hashCode(o);
    h += (h << 5) + l.hashCode();
    h += (h << 5) + Objects.hashCode(i);
    h += (h << 5) + Objects.hashCode(d);
    h += (h << 5) + oi.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WithMapUnary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WithMapUnary")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("o", o)
        .add("l", l)
        .add("i", i)
        .add("d", d)
        .add("oi", oi.orNull())
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link WithMapUnary} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WithMapUnary instance
   */
  public static ImmutableWithMapUnary copyOf(WithMapUnary instance) {
    if (instance instanceof ImmutableWithMapUnary) {
      return (ImmutableWithMapUnary) instance;
    }
    return new WithMapUnary.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableWithMapUnary ImmutableWithMapUnary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WithMapUnary", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private int a;
    private @Nullable String b;
    private @Nullable String o;
    private ImmutableList.Builder<String> l = ImmutableList.builder();
    private @Nullable Integer i;
    private @Nullable Double d;
    private Optional<Integer> oi = Optional.absent();

    /**
     * Creates a builder for {@link ImmutableWithMapUnary ImmutableWithMapUnary} instances.
     * <pre>
     * new WithMapUnary.Builder()
     *    .a(int) // required {@link WithMapUnary#a() a}
     *    .b(String) // required {@link WithMapUnary#b() b}
     *    .o(String) // optional {@link WithMapUnary#o() o}
     *    .addL|addAllL(String) // {@link WithMapUnary#l() l} elements
     *    .i(int) // optional {@link WithMapUnary#i() i}
     *    .d(double) // optional {@link WithMapUnary#d() d}
     *    .oi(Integer) // optional {@link WithMapUnary#oi() oi}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof WithMapUnary.Builder)) {
        throw new UnsupportedOperationException("Use: new WithMapUnary.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.with.WithMapUnary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder from(WithMapUnary instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (WithMapUnary.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.with.WithUnaryOperator} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder from(WithUnaryOperator instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (WithMapUnary.Builder) this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof WithMapUnary) {
        WithMapUnary instance = (WithMapUnary) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          b(instance.b());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          OptionalDouble dOptional = instance.d();
          if (dOptional.isPresent()) {
            d(dOptional);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          OptionalInt iOptional = instance.i();
          if (iOptional.isPresent()) {
            i(iOptional);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          Optional<Integer> oiOptional = instance.oi();
          if (oiOptional.isPresent()) {
            oi(oiOptional);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          addAllL(instance.l());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          java.util.Optional<String> oOptional = instance.o();
          if (oOptional.isPresent()) {
            o(oOptional);
          }
          bits |= 0x40L;
        }
      }
      if (object instanceof WithUnaryOperator) {
        WithUnaryOperator instance = (WithUnaryOperator) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          b(instance.b());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          OptionalDouble dOptional = instance.d();
          if (dOptional.isPresent()) {
            d(dOptional);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          OptionalInt iOptional = instance.i();
          if (iOptional.isPresent()) {
            i(iOptional);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          Optional<Integer> oiOptional = instance.oi();
          if (oiOptional.isPresent()) {
            oi(oiOptional);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          addAllL(instance.l());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          java.util.Optional<String> oOptional = instance.o();
          if (oOptional.isPresent()) {
            o(oOptional);
          }
          bits |= 0x40L;
        }
      }
    }

    /**
     * Initializes the value for the {@link WithMapUnary#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return (WithMapUnary.Builder) this;
    }

    /**
     * Initializes the value for the {@link WithMapUnary#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return (WithMapUnary.Builder) this;
    }

    /**
     * Initializes the optional value {@link WithMapUnary#o() o} to o.
     * @param o The value for o
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder o(String o) {
      this.o = Objects.requireNonNull(o, "o");
      return (WithMapUnary.Builder) this;
    }

    /**
     * Initializes the optional value {@link WithMapUnary#o() o} to o.
     * @param o The value for o
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder o(java.util.Optional<String> o) {
      this.o = o.orElse(null);
      return (WithMapUnary.Builder) this;
    }

    /**
     * Adds one element to {@link WithMapUnary#l() l} list.
     * @param element A l element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder addL(String element) {
      this.l.add(element);
      return (WithMapUnary.Builder) this;
    }

    /**
     * Adds elements to {@link WithMapUnary#l() l} list.
     * @param elements An array of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder addL(String... elements) {
      this.l.add(elements);
      return (WithMapUnary.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link WithMapUnary#l() l} list.
     * @param elements An iterable of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder l(Iterable<String> elements) {
      this.l = ImmutableList.builder();
      return addAllL(elements);
    }

    /**
     * Adds elements to {@link WithMapUnary#l() l} list.
     * @param elements An iterable of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder addAllL(Iterable<String> elements) {
      this.l.addAll(elements);
      return (WithMapUnary.Builder) this;
    }

    /**
     * Initializes the optional value {@link WithMapUnary#i() i} to i.
     * @param i The value for i
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder i(int i) {
      this.i = i;
      return (WithMapUnary.Builder) this;
    }

    /**
     * Initializes the optional value {@link WithMapUnary#i() i} to i.
     * @param i The value for i
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder i(OptionalInt i) {
      this.i = i.isPresent() ? i.getAsInt() : null;
      return (WithMapUnary.Builder) this;
    }

    /**
     * Initializes the optional value {@link WithMapUnary#d() d} to d.
     * @param d The value for d
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder d(double d) {
      this.d = d;
      return (WithMapUnary.Builder) this;
    }

    /**
     * Initializes the optional value {@link WithMapUnary#d() d} to d.
     * @param d The value for d
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder d(OptionalDouble d) {
      this.d = d.isPresent() ? d.getAsDouble() : null;
      return (WithMapUnary.Builder) this;
    }

    /**
     * Initializes the optional value {@link WithMapUnary#oi() oi} to oi.
     * @param oi The value for oi
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder oi(int oi) {
      this.oi = Optional.of(oi);
      return (WithMapUnary.Builder) this;
    }

    /**
     * Initializes the optional value {@link WithMapUnary#oi() oi} to oi.
     * @param oi The value for oi
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final WithMapUnary.Builder oi(Optional<Integer> oi) {
      this.oi = oi;
      return (WithMapUnary.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableWithMapUnary ImmutableWithMapUnary}.
     * @return An immutable instance of WithMapUnary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWithMapUnary build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWithMapUnary(a, b, o, l.build(), i, d, oi);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build WithMapUnary, some of required attributes are not set " + attributes;
    }
  }
}
