package org.immutables.fixture.with;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WithEnums}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWithEnums.builder()}.
 */
@Generated(from = "WithEnums", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWithEnums extends WithEnums {
  private final RoundingMode roundingMode;
  private final @Nullable RoundingMode nullableRoundingMode;
  private final @Nullable RoundingMode maybeRoundingMode;

  private ImmutableWithEnums(
      RoundingMode roundingMode,
      @Nullable RoundingMode nullableRoundingMode,
      @Nullable RoundingMode maybeRoundingMode) {
    this.roundingMode = roundingMode;
    this.nullableRoundingMode = nullableRoundingMode;
    this.maybeRoundingMode = maybeRoundingMode;
  }

  /**
   * @return The value of the {@code roundingMode} attribute
   */
  @Override
  public RoundingMode getRoundingMode() {
    return roundingMode;
  }

  /**
   * @return The value of the {@code nullableRoundingMode} attribute
   */
  @Override
  public @Nullable RoundingMode getNullableRoundingMode() {
    return nullableRoundingMode;
  }

  /**
   * @return The value of the {@code maybeRoundingMode} attribute
   */
  @Override
  public Optional<RoundingMode> getMaybeRoundingMode() {
    return Optional.ofNullable(maybeRoundingMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WithEnums#getRoundingMode() roundingMode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for roundingMode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithEnums withRoundingMode(RoundingMode value) {
    RoundingMode newValue = Objects.requireNonNull(value, "roundingMode");
    if (this.roundingMode == newValue) return this;
    return new ImmutableWithEnums(newValue, this.nullableRoundingMode, this.maybeRoundingMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WithEnums#getNullableRoundingMode() nullableRoundingMode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullableRoundingMode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithEnums withNullableRoundingMode(@Nullable RoundingMode value) {
    if (this.nullableRoundingMode == value) return this;
    return new ImmutableWithEnums(this.roundingMode, value, this.maybeRoundingMode);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WithEnums#getMaybeRoundingMode() maybeRoundingMode} attribute.
   * @param value The value for maybeRoundingMode
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithEnums withMaybeRoundingMode(RoundingMode value) {
    RoundingMode newValue = Objects.requireNonNull(value, "maybeRoundingMode");
    if (this.maybeRoundingMode == newValue) return this;
    return new ImmutableWithEnums(this.roundingMode, this.nullableRoundingMode, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WithEnums#getMaybeRoundingMode() maybeRoundingMode} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for maybeRoundingMode
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableWithEnums withMaybeRoundingMode(Optional<? extends RoundingMode> optional) {
    @Nullable RoundingMode value = optional.orElse(null);
    if (this.maybeRoundingMode == value) return this;
    return new ImmutableWithEnums(this.roundingMode, this.nullableRoundingMode, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWithEnums} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWithEnums
        && equalTo(0, (ImmutableWithEnums) another);
  }

  private boolean equalTo(int synthetic, ImmutableWithEnums another) {
    return roundingMode.equals(another.roundingMode)
        && Objects.equals(nullableRoundingMode, another.nullableRoundingMode)
        && Objects.equals(maybeRoundingMode, another.maybeRoundingMode);
  }

  /**
   * Computes a hash code from attributes: {@code roundingMode}, {@code nullableRoundingMode}, {@code maybeRoundingMode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + roundingMode.hashCode();
    h += (h << 5) + Objects.hashCode(nullableRoundingMode);
    h += (h << 5) + Objects.hashCode(maybeRoundingMode);
    return h;
  }

  /**
   * Prints the immutable value {@code WithEnums} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WithEnums")
        .omitNullValues()
        .add("roundingMode", roundingMode)
        .add("nullableRoundingMode", nullableRoundingMode)
        .add("maybeRoundingMode", maybeRoundingMode)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link WithEnums} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WithEnums instance
   */
  public static ImmutableWithEnums copyOf(WithEnums instance) {
    if (instance instanceof ImmutableWithEnums) {
      return (ImmutableWithEnums) instance;
    }
    return ImmutableWithEnums.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWithEnums ImmutableWithEnums}.
   * <pre>
   * ImmutableWithEnums.builder()
   *    .roundingMode(java.math.RoundingMode) // required {@link WithEnums#getRoundingMode() roundingMode}
   *    .nullableRoundingMode(java.math.RoundingMode | null) // nullable {@link WithEnums#getNullableRoundingMode() nullableRoundingMode}
   *    .maybeRoundingMode(java.math.RoundingMode) // optional {@link WithEnums#getMaybeRoundingMode() maybeRoundingMode}
   *    .build();
   * </pre>
   * @return A new ImmutableWithEnums builder
   */
  public static ImmutableWithEnums.Builder builder() {
    return new ImmutableWithEnums.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWithEnums ImmutableWithEnums}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WithEnums", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ROUNDING_MODE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable RoundingMode roundingMode;
    private @Nullable RoundingMode nullableRoundingMode;
    private @Nullable RoundingMode maybeRoundingMode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WithEnums} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WithEnums instance) {
      Objects.requireNonNull(instance, "instance");
      roundingMode(instance.getRoundingMode());
      @Nullable RoundingMode nullableRoundingModeValue = instance.getNullableRoundingMode();
      if (nullableRoundingModeValue != null) {
        nullableRoundingMode(nullableRoundingModeValue);
      }
      Optional<RoundingMode> maybeRoundingModeOptional = instance.getMaybeRoundingMode();
      if (maybeRoundingModeOptional.isPresent()) {
        maybeRoundingMode(maybeRoundingModeOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link WithEnums#getRoundingMode() roundingMode} attribute.
     * @param roundingMode The value for roundingMode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder roundingMode(RoundingMode roundingMode) {
      this.roundingMode = Objects.requireNonNull(roundingMode, "roundingMode");
      initBits &= ~INIT_BIT_ROUNDING_MODE;
      return this;
    }

    /**
     * Initializes the value for the {@link WithEnums#getNullableRoundingMode() nullableRoundingMode} attribute.
     * @param nullableRoundingMode The value for nullableRoundingMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nullableRoundingMode(@Nullable RoundingMode nullableRoundingMode) {
      this.nullableRoundingMode = nullableRoundingMode;
      return this;
    }

    /**
     * Initializes the optional value {@link WithEnums#getMaybeRoundingMode() maybeRoundingMode} to maybeRoundingMode.
     * @param maybeRoundingMode The value for maybeRoundingMode
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder maybeRoundingMode(RoundingMode maybeRoundingMode) {
      this.maybeRoundingMode = Objects.requireNonNull(maybeRoundingMode, "maybeRoundingMode");
      return this;
    }

    /**
     * Initializes the optional value {@link WithEnums#getMaybeRoundingMode() maybeRoundingMode} to maybeRoundingMode.
     * @param maybeRoundingMode The value for maybeRoundingMode
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder maybeRoundingMode(Optional<? extends RoundingMode> maybeRoundingMode) {
      this.maybeRoundingMode = maybeRoundingMode.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableWithEnums ImmutableWithEnums}.
     * @return An immutable instance of WithEnums
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWithEnums build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWithEnums(roundingMode, nullableRoundingMode, maybeRoundingMode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUNDING_MODE) != 0) attributes.add("roundingMode");
      return "Cannot build WithEnums, some of required attributes are not set " + attributes;
    }
  }
}
