package org.immutables.fixture.synthetic;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Synthetic}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSynthetic.builder()}.
 */
@Generated(from = "Synthetic", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSynthetic implements Synthetic {
  private final int synthetic;

  private ImmutableSynthetic(int synthetic) {
    this.synthetic = synthetic;
  }

  /**
   * @return The value of the {@code synthetic} attribute
   */
  @Override
  public int synthetic() {
    return synthetic;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Synthetic#synthetic() synthetic} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for synthetic
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSynthetic withSynthetic(int value) {
    if (this.synthetic == value) return this;
    return new ImmutableSynthetic(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSynthetic} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSynthetic
        && equalTo(0, (ImmutableSynthetic) another);
  }

  private boolean equalTo(int synthetic, ImmutableSynthetic another) {
    return this.synthetic == another.synthetic;
  }

  /**
   * Computes a hash code from attributes: {@code synthetic}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + synthetic;
    return h;
  }

  /**
   * Prints the immutable value {@code Synthetic} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Synthetic")
        .omitNullValues()
        .add("synthetic", synthetic)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Synthetic} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Synthetic instance
   */
  public static ImmutableSynthetic copyOf(Synthetic instance) {
    if (instance instanceof ImmutableSynthetic) {
      return (ImmutableSynthetic) instance;
    }
    return ImmutableSynthetic.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSynthetic ImmutableSynthetic}.
   * <pre>
   * ImmutableSynthetic.builder()
   *    .synthetic(int) // required {@link Synthetic#synthetic() synthetic}
   *    .build();
   * </pre>
   * @return A new ImmutableSynthetic builder
   */
  public static ImmutableSynthetic.Builder builder() {
    return new ImmutableSynthetic.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSynthetic ImmutableSynthetic}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Synthetic", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SYNTHETIC = 0x1L;
    private long initBits = 0x1L;

    private int synthetic;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Synthetic} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Synthetic instance) {
      Objects.requireNonNull(instance, "instance");
      synthetic(instance.synthetic());
      return this;
    }

    /**
     * Initializes the value for the {@link Synthetic#synthetic() synthetic} attribute.
     * @param synthetic The value for synthetic 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder synthetic(int synthetic) {
      this.synthetic = synthetic;
      initBits &= ~INIT_BIT_SYNTHETIC;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSynthetic ImmutableSynthetic}.
     * @return An immutable instance of Synthetic
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSynthetic build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSynthetic(synthetic);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SYNTHETIC) != 0) attributes.add("synthetic");
      return "Cannot build Synthetic, some of required attributes are not set " + attributes;
    }
  }
}
