package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OverrideColor}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code OverrideColorTuple.of()}.
 */
@Generated(from = "OverrideColor", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class OverrideColorTuple implements OverrideColor {
  private final int white;
  private final int black;
  private final int gray;

  private OverrideColorTuple(int white, int black) {
    this.white = white;
    this.black = black;
    this.gray = OverrideColor.super.gray();
  }

  private OverrideColorTuple(int white, int black, int gray) {
    this.white = white;
    this.black = black;
    this.gray = gray;
  }

  /**
   * @return The value of the {@code white} attribute
   */
  @Override
  public int white() {
    return white;
  }

  /**
   * @return The value of the {@code black} attribute
   */
  @Override
  public int black() {
    return black;
  }

  /**
   * @return The value of the {@code gray} attribute
   */
  @Override
  public int gray() {
    return gray;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OverrideColor#white() white} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for white
   * @return A modified copy of the {@code this} object
   */
  public final OverrideColorTuple withWhite(int value) {
    if (this.white == value) return this;
    return new OverrideColorTuple(value, this.black, this.gray);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OverrideColor#black() black} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for black
   * @return A modified copy of the {@code this} object
   */
  public final OverrideColorTuple withBlack(int value) {
    if (this.black == value) return this;
    return new OverrideColorTuple(this.white, value, this.gray);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OverrideColor#gray() gray} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gray
   * @return A modified copy of the {@code this} object
   */
  public final OverrideColorTuple withGray(int value) {
    if (this.gray == value) return this;
    return new OverrideColorTuple(this.white, this.black, value);
  }

  /**
   * This instance is equal to all instances of {@code OverrideColorTuple} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof OverrideColorTuple
        && equalTo(0, (OverrideColorTuple) another);
  }

  private boolean equalTo(int synthetic, OverrideColorTuple another) {
    return white == another.white
        && black == another.black
        && gray == another.gray;
  }

  /**
   * Computes a hash code from attributes: {@code white}, {@code black}, {@code gray}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + white;
    h += (h << 5) + black;
    h += (h << 5) + gray;
    return h;
  }

  /**
   * Prints the immutable value {@code OverrideColor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OverrideColor")
        .omitNullValues()
        .add("white", white)
        .add("black", black)
        .add("gray", gray)
        .toString();
  }

  /**
   * Construct a new immutable {@code OverrideColor} instance.
   * @param white The value for the {@code white} attribute
   * @param black The value for the {@code black} attribute
   * @return An immutable OverrideColor instance
   */
  public static OverrideColorTuple of(int white, int black) {
    return new OverrideColorTuple(white, black);
  }

  /**
   * Creates an immutable copy of a {@link OverrideColor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OverrideColor instance
   */
  public static OverrideColorTuple copyOf(OverrideColor instance) {
    if (instance instanceof OverrideColorTuple) {
      return (OverrideColorTuple) instance;
    }
    return OverrideColorTuple.of(instance.white(), instance.black())
        .withGray(instance.gray());
  }
}
