package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link UnderrideObjectMethods UnderrideObjectMethods} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableUnderrideObjectMethods is not thread-safe</em>
 * @see ImmutableUnderrideObjectMethods
 */
@Generated(from = "UnderrideObjectMethods", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "UnderrideObjectMethods"})
@NotThreadSafe
public final class ModifiableUnderrideObjectMethods
    implements UnderrideObjectMethods {
  private static final long INIT_BIT_A = 0x1L;
  private long initBits = 0x1L;

  private int a;

  private ModifiableUnderrideObjectMethods() {}

  /**
   * Construct a modifiable instance of {@code UnderrideObjectMethods}.
   * @return A new modifiable instance
   */
  public static ModifiableUnderrideObjectMethods create() {
    return new ModifiableUnderrideObjectMethods();
  }

  /**
   * @return value of {@code a} attribute
   */
  @Override
  public final int a() {
    if (!aIsSet()) {
      checkRequiredAttributes();
    }
    return a;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableUnderrideObjectMethods clear() {
    initBits = 0x1L;
    a = 0;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link UnderrideObjectMethods} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableUnderrideObjectMethods from(UnderrideObjectMethods instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableUnderrideObjectMethods) {
      from((ModifiableUnderrideObjectMethods) instance);
      return this;
    }
    setA(instance.a());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link UnderrideObjectMethods} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableUnderrideObjectMethods from(ModifiableUnderrideObjectMethods instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.aIsSet()) {
      setA(instance.a());
    }
    return this;
  }

  /**
   * Assigns a value to the {@link UnderrideObjectMethods#a() a} attribute.
   * @param a The value for a
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableUnderrideObjectMethods setA(int a) {
    this.a = a;
    initBits &= ~INIT_BIT_A;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link UnderrideObjectMethods#a() a} is set.
   * @return {@code true} if set
   */
  public final boolean aIsSet() {
    return (initBits & INIT_BIT_A) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableUnderrideObjectMethods unsetA() {
    initBits |= INIT_BIT_A;
    a = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!aIsSet()) attributes.add("a");
    return "UnderrideObjectMethods is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableUnderrideObjectMethods ImmutableUnderrideObjectMethods}.
   * @return An immutable instance of UnderrideObjectMethods
   */
  public final ImmutableUnderrideObjectMethods toImmutable() {
    checkRequiredAttributes();
    return ImmutableUnderrideObjectMethods.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableUnderrideObjectMethods} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableUnderrideObjectMethods)) return false;
    ModifiableUnderrideObjectMethods other = (ModifiableUnderrideObjectMethods) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableUnderrideObjectMethods another) {
    return UnderrideObjectMethods.super.equalTo(another);
  }

  public final int hashCode() {
    if (!isInitialized()) return 1927847415;
    return UnderrideObjectMethods.super.hash();
  }

  /**
  * Prints the immutable value {@code UnderrideObjectMethods} delegating to a customized method.
  * @return A string representation of the value
  */
  @Override
  public String toString() {
    return UnderrideObjectMethods.super.stringify();
  }
}
