package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.SampleRuntimeException;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SpecifiedException}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSpecifiedException.builder()}.
 */
@Generated(from = "SpecifiedException", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSpecifiedException implements SpecifiedException {
  private final int someRequiredInteger;
  private final String someRequiredString;

  private ImmutableSpecifiedException(int someRequiredInteger, String someRequiredString) {
    this.someRequiredInteger = someRequiredInteger;
    this.someRequiredString = someRequiredString;
  }

  /**
   * @return The value of the {@code someRequiredInteger} attribute
   */
  @Override
  public int getSomeRequiredInteger() {
    return someRequiredInteger;
  }

  /**
   * @return The value of the {@code someRequiredString} attribute
   */
  @Override
  public String getSomeRequiredString() {
    return someRequiredString;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecifiedException#getSomeRequiredInteger() someRequiredInteger} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for someRequiredInteger
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpecifiedException withSomeRequiredInteger(int value) {
    if (this.someRequiredInteger == value) return this;
    return new ImmutableSpecifiedException(value, this.someRequiredString);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecifiedException#getSomeRequiredString() someRequiredString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for someRequiredString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpecifiedException withSomeRequiredString(String value) {
    String newValue = ImmutableSpecifiedException.requireNonNull(value, "someRequiredString");
    if (this.someRequiredString.equals(newValue)) return this;
    return new ImmutableSpecifiedException(this.someRequiredInteger, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSpecifiedException} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSpecifiedException
        && equalTo(0, (ImmutableSpecifiedException) another);
  }

  private boolean equalTo(int synthetic, ImmutableSpecifiedException another) {
    return someRequiredInteger == another.someRequiredInteger
        && someRequiredString.equals(another.someRequiredString);
  }

  /**
   * Computes a hash code from attributes: {@code someRequiredInteger}, {@code someRequiredString}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + someRequiredInteger;
    h += (h << 5) + someRequiredString.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SpecifiedException} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SpecifiedException")
        .omitNullValues()
        .add("someRequiredInteger", someRequiredInteger)
        .add("someRequiredString", someRequiredString)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SpecifiedException} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SpecifiedException instance
   */
  public static ImmutableSpecifiedException copyOf(SpecifiedException instance) {
    if (instance instanceof ImmutableSpecifiedException) {
      return (ImmutableSpecifiedException) instance;
    }
    return ImmutableSpecifiedException.builder()
        .someRequiredInteger(instance.getSomeRequiredInteger())
        .someRequiredString(instance.getSomeRequiredString())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSpecifiedException ImmutableSpecifiedException}.
   * <pre>
   * ImmutableSpecifiedException.builder()
   *    .someRequiredInteger(int) // required {@link SpecifiedException#getSomeRequiredInteger() someRequiredInteger}
   *    .someRequiredString(String) // required {@link SpecifiedException#getSomeRequiredString() someRequiredString}
   *    .build();
   * </pre>
   * @return A new ImmutableSpecifiedException builder
   */
  public static ImmutableSpecifiedException.Builder builder() {
    return new ImmutableSpecifiedException.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSpecifiedException ImmutableSpecifiedException}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SpecifiedException", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOME_REQUIRED_INTEGER = 0x1L;
    private static final long INIT_BIT_SOME_REQUIRED_STRING = 0x2L;
    private long initBits = 0x3L;

    private int someRequiredInteger;
    private @Nullable String someRequiredString;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link SpecifiedException#getSomeRequiredInteger() someRequiredInteger} attribute.
     * @param someRequiredInteger The value for someRequiredInteger 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder someRequiredInteger(int someRequiredInteger) {
      checkNotIsSet(someRequiredIntegerIsSet(), "someRequiredInteger");
      this.someRequiredInteger = someRequiredInteger;
      initBits &= ~INIT_BIT_SOME_REQUIRED_INTEGER;
      return this;
    }

    /**
     * Initializes the value for the {@link SpecifiedException#getSomeRequiredString() someRequiredString} attribute.
     * @param someRequiredString The value for someRequiredString 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder someRequiredString(String someRequiredString) {
      checkNotIsSet(someRequiredStringIsSet(), "someRequiredString");
      this.someRequiredString = ImmutableSpecifiedException.requireNonNull(someRequiredString, "someRequiredString");
      initBits &= ~INIT_BIT_SOME_REQUIRED_STRING;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSpecifiedException ImmutableSpecifiedException}.
     * @return An immutable instance of SpecifiedException
     * @throws nonimmutables.SampleRuntimeException if any required attributes are missing
     */
    public ImmutableSpecifiedException build() {
      checkRequiredAttributes();
      return new ImmutableSpecifiedException(someRequiredInteger, someRequiredString);
    }

    /**
     * Builds a new {@link ImmutableSpecifiedException ImmutableSpecifiedException}.
     * @param <BOT> exception type
     * @param exceptionSupplier used to create new exception from supplied error message
     * @return An immutable instance of SpecifiedException
     * @throws BOT The supplied exception {@code BOT} if any required attributes are missing
     */
    public <BOT extends Exception> ImmutableSpecifiedException buildOrThrow(Function<String, BOT> exceptionSupplier)
        throws BOT {
      checkRequiredAttributesOrThrow(exceptionSupplier);
      return new ImmutableSpecifiedException(someRequiredInteger, someRequiredString);
    }

    private boolean someRequiredIntegerIsSet() {
      return (initBits & INIT_BIT_SOME_REQUIRED_INTEGER) == 0;
    }

    private boolean someRequiredStringIsSet() {
      return (initBits & INIT_BIT_SOME_REQUIRED_STRING) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of SpecifiedException is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new SampleRuntimeException(formatRequiredAttributesMessage());
      }
    }

    private <T extends Exception> void checkRequiredAttributesOrThrow(Function<String, T> exceptionSupplier) throws T {
      if (initBits != 0) {
        throw exceptionSupplier.apply(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!someRequiredIntegerIsSet()) attributes.add("someRequiredInteger");
      if (!someRequiredStringIsSet()) attributes.add("someRequiredString");
      return "Cannot build SpecifiedException, some of required attributes are not set " + attributes;
    }
  }

  private static <T> T requireNonNull(T object, String message) {
    if (object == null) throw new SampleRuntimeException(message);
    return object;
  }
}
