package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NoBuiltinContainers}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNoBuiltinContainers.builder()}.
 */
@Generated(from = "NoBuiltinContainers", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNoBuiltinContainers implements NoBuiltinContainers {
  private final Map<Integer, Double> a;
  private final List<String> b;
  private final Optional<String> c;

  private ImmutableNoBuiltinContainers(
      Map<Integer, Double> a,
      List<String> b,
      Optional<String> c) {
    this.a = a;
    this.b = b;
    this.c = c;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public Map<Integer, Double> a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public List<String> b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public Optional<String> c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoBuiltinContainers#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoBuiltinContainers withA(Map<Integer, Double> value) {
    Map<Integer, Double> newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableNoBuiltinContainers(newValue, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoBuiltinContainers#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoBuiltinContainers withB(List<String> value) {
    if (this.b == value) return this;
    List<String> newValue = Objects.requireNonNull(value, "b");
    return new ImmutableNoBuiltinContainers(this.a, newValue, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoBuiltinContainers#c() c} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoBuiltinContainers withC(Optional<String> value) {
    Optional<String> newValue = Objects.requireNonNull(value, "c");
    if (this.c.equals(newValue)) return this;
    return new ImmutableNoBuiltinContainers(this.a, this.b, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNoBuiltinContainers} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNoBuiltinContainers
        && equalTo(0, (ImmutableNoBuiltinContainers) another);
  }

  private boolean equalTo(int synthetic, ImmutableNoBuiltinContainers another) {
    return a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NoBuiltinContainers} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NoBuiltinContainers")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NoBuiltinContainers} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NoBuiltinContainers instance
   */
  public static ImmutableNoBuiltinContainers copyOf(NoBuiltinContainers instance) {
    if (instance instanceof ImmutableNoBuiltinContainers) {
      return (ImmutableNoBuiltinContainers) instance;
    }
    return ImmutableNoBuiltinContainers.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNoBuiltinContainers ImmutableNoBuiltinContainers}.
   * <pre>
   * ImmutableNoBuiltinContainers.builder()
   *    .a(Map&amp;lt;Integer, Double&amp;gt;) // required {@link NoBuiltinContainers#a() a}
   *    .b(List&amp;lt;String&amp;gt;) // required {@link NoBuiltinContainers#b() b}
   *    .c(Optional&amp;lt;String&amp;gt;) // required {@link NoBuiltinContainers#c() c}
   *    .build();
   * </pre>
   * @return A new ImmutableNoBuiltinContainers builder
   */
  public static ImmutableNoBuiltinContainers.Builder builder() {
    return new ImmutableNoBuiltinContainers.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNoBuiltinContainers ImmutableNoBuiltinContainers}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NoBuiltinContainers", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_C = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Map<Integer, Double> a;
    private @Nullable List<String> b;
    private @Nullable Optional<String> c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NoBuiltinContainers} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NoBuiltinContainers instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link NoBuiltinContainers#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(Map<Integer, Double> a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link NoBuiltinContainers#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(List<String> b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link NoBuiltinContainers#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(Optional<String> c) {
      this.c = Objects.requireNonNull(c, "c");
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNoBuiltinContainers ImmutableNoBuiltinContainers}.
     * @return An immutable instance of NoBuiltinContainers
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNoBuiltinContainers build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNoBuiltinContainers(a, b, c);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build NoBuiltinContainers, some of required attributes are not set " + attributes;
    }
  }
}
