package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LoweredVisibility}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLoweredVisibility.builder()}.
 */
@Generated(from = "LoweredVisibility", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableLoweredVisibility extends LoweredVisibility {

  private ImmutableLoweredVisibility(ImmutableLoweredVisibility.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLoweredVisibility} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLoweredVisibility
        && equalTo(0, (ImmutableLoweredVisibility) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableLoweredVisibility another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1044156732;
  }

  /**
   * Prints the immutable value {@code LoweredVisibility}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LoweredVisibility{}";
  }

  /**
   * Creates an immutable copy of a {@link LoweredVisibility} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LoweredVisibility instance
   */
  public static ImmutableLoweredVisibility copyOf(LoweredVisibility instance) {
    if (instance instanceof ImmutableLoweredVisibility) {
      return (ImmutableLoweredVisibility) instance;
    }
    return ImmutableLoweredVisibility.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLoweredVisibility ImmutableLoweredVisibility}.
   * <pre>
   * ImmutableLoweredVisibility.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableLoweredVisibility builder
   */
  public static ImmutableLoweredVisibility.Builder builder() {
    return new ImmutableLoweredVisibility.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLoweredVisibility ImmutableLoweredVisibility}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LoweredVisibility", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LoweredVisibility} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LoweredVisibility instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableLoweredVisibility ImmutableLoweredVisibility}.
     * @return An immutable instance of LoweredVisibility
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLoweredVisibility build() {
      return new ImmutableLoweredVisibility(this);
    }
  }
}
