package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Constr.Rev}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImRev.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code new ImRev()}.
 */
@Generated(from = "Constr.Rev", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImRev implements Constr.Rev {
  private final int major;
  private final int minor;

  /**
   * Construct a new immutable {@code Rev} instance.
   * @param major The value for the {@code major} attribute
   * @param minor The value for the {@code minor} attribute
   */
  public ImRev(int major, int minor) {
    this.major = major;
    this.minor = minor;
  }

  /**
   * @return The value of the {@code major} attribute
   */
  @Override
  public int major() {
    return major;
  }

  /**
   * @return The value of the {@code minor} attribute
   */
  @Override
  public int minor() {
    return minor;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constr.Rev#major() major} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for major
   * @return A modified copy of the {@code this} object
   */
  public final ImRev withMajor(int value) {
    if (this.major == value) return this;
    return new ImRev(value, this.minor);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constr.Rev#minor() minor} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minor
   * @return A modified copy of the {@code this} object
   */
  public final ImRev withMinor(int value) {
    if (this.minor == value) return this;
    return new ImRev(this.major, value);
  }

  /**
   * This instance is equal to all instances of {@code ImRev} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImRev
        && equalTo(0, (ImRev) another);
  }

  private boolean equalTo(int synthetic, ImRev another) {
    return major == another.major
        && minor == another.minor;
  }

  /**
   * Computes a hash code from attributes: {@code major}, {@code minor}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + major;
    h += (h << 5) + minor;
    return h;
  }

  /**
   * Prints the immutable value {@code Rev} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Rev")
        .omitNullValues()
        .add("major", major)
        .add("minor", minor)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Constr.Rev} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Rev instance
   */
  public static ImRev copyOf(Constr.Rev instance) {
    if (instance instanceof ImRev) {
      return (ImRev) instance;
    }
    return ImRev.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImRev ImRev}.
   * <pre>
   * ImRev.builder()
   *    .major(int) // required {@link Constr.Rev#major() major}
   *    .minor(int) // required {@link Constr.Rev#minor() minor}
   *    .build();
   * </pre>
   * @return A new ImRev builder
   */
  public static ImRev.Builder builder() {
    return new ImRev.Builder();
  }

  /**
   * Builds instances of type {@link ImRev ImRev}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Constr.Rev", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MAJOR = 0x1L;
    private static final long INIT_BIT_MINOR = 0x2L;
    private long initBits = 0x3L;

    private int major;
    private int minor;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Rev} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Constr.Rev instance) {
      Objects.requireNonNull(instance, "instance");
      major(instance.major());
      minor(instance.minor());
      return this;
    }

    /**
     * Initializes the value for the {@link Constr.Rev#major() major} attribute.
     * @param major The value for major 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder major(int major) {
      this.major = major;
      initBits &= ~INIT_BIT_MAJOR;
      return this;
    }

    /**
     * Initializes the value for the {@link Constr.Rev#minor() minor} attribute.
     * @param minor The value for minor 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder minor(int minor) {
      this.minor = minor;
      initBits &= ~INIT_BIT_MINOR;
      return this;
    }

    /**
     * Builds a new {@link ImRev ImRev}.
     * @return An immutable instance of Rev
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImRev build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImRev(major, minor);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MAJOR) != 0) attributes.add("major");
      if ((initBits & INIT_BIT_MINOR) != 0) attributes.add("minor");
      return "Cannot build Rev, some of required attributes are not set " + attributes;
    }
  }
}
