package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Builds instances of type {@link HiddenImplementation HiddenImplementation}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code HiddenImplementationBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "HiddenImplementation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class HiddenImplementationBuilder {

  /**
   * Creates a builder for {@link HiddenImplementation HiddenImplementation} instances.
   * <pre>
   * new HiddenImplementationBuilder()
   *    .build();
   * </pre>
   */
  public HiddenImplementationBuilder() {
  }

  /**
   * Fill a builder with attribute values from the provided {@code HiddenImplementation} instance.
   * Regular attribute values will be replaced with those from the given instance.
   * Absent optional values will not replace present values.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final HiddenImplementationBuilder from(HiddenImplementation instance) {
    Objects.requireNonNull(instance, "instance");
    return this;
  }

  /**
   * Builds a new {@link HiddenImplementation HiddenImplementation}.
   * @return An immutable instance of HiddenImplementation
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public HiddenImplementation build() {
    return new HiddenImplementationBuilder.ImmutableHiddenImplementation(this);
  }

  /**
   * Immutable implementation of {@link HiddenImplementation}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new HiddenImplementationBuilder()}.
   */
  @Generated(from = "HiddenImplementation", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  private static final class ImmutableHiddenImplementation extends HiddenImplementation {

    private ImmutableHiddenImplementation(HiddenImplementationBuilder builder) {
    }

    /**
     * This instance is equal to all instances of {@code ImmutableHiddenImplementation} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof HiddenImplementationBuilder.ImmutableHiddenImplementation
          && equalTo(0, (HiddenImplementationBuilder.ImmutableHiddenImplementation) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(int synthetic, HiddenImplementationBuilder.ImmutableHiddenImplementation another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 256755120;
    }

    /**
     * Prints the immutable value {@code HiddenImplementation}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "HiddenImplementation{}";
    }
  }
}
