package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Color}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ColorTuple.of()}.
 */
@Generated(from = "Color", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ColorTuple implements Color {
  private final int red;
  private final int green;
  private final int blue;

  private ColorTuple(int red, int green, int blue) {
    this.red = red;
    this.green = green;
    this.blue = blue;
  }

  /**
   * @return The value of the {@code red} attribute
   */
  @Override
  public int red() {
    return red;
  }

  /**
   * @return The value of the {@code green} attribute
   */
  @Override
  public int green() {
    return green;
  }

  /**
   * @return The value of the {@code blue} attribute
   */
  @Override
  public int blue() {
    return blue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Color#red() red} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for red
   * @return A modified copy of the {@code this} object
   */
  public final ColorTuple withRed(int value) {
    if (this.red == value) return this;
    return new ColorTuple(value, this.green, this.blue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Color#green() green} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for green
   * @return A modified copy of the {@code this} object
   */
  public final ColorTuple withGreen(int value) {
    if (this.green == value) return this;
    return new ColorTuple(this.red, value, this.blue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Color#blue() blue} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blue
   * @return A modified copy of the {@code this} object
   */
  public final ColorTuple withBlue(int value) {
    if (this.blue == value) return this;
    return new ColorTuple(this.red, this.green, value);
  }

  /**
   * This instance is equal to all instances of {@code ColorTuple} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ColorTuple
        && equalTo(0, (ColorTuple) another);
  }

  private boolean equalTo(int synthetic, ColorTuple another) {
    return red == another.red
        && green == another.green
        && blue == another.blue;
  }

  /**
   * Computes a hash code from attributes: {@code red}, {@code green}, {@code blue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + red;
    h += (h << 5) + green;
    h += (h << 5) + blue;
    return h;
  }

  /**
   * Prints the immutable value {@code Color} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Color")
        .omitNullValues()
        .add("red", red)
        .add("green", green)
        .add("blue", blue)
        .toString();
  }

  /**
   * Construct a new immutable {@code Color} instance.
   * @param red The value for the {@code red} attribute
   * @param green The value for the {@code green} attribute
   * @param blue The value for the {@code blue} attribute
   * @return An immutable Color instance
   */
  public static ColorTuple of(int red, int green, int blue) {
    return new ColorTuple(red, green, blue);
  }

  /**
   * Creates an immutable copy of a {@link Color} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Color instance
   */
  public static ColorTuple copyOf(Color instance) {
    if (instance instanceof ColorTuple) {
      return (ColorTuple) instance;
    }
    return ColorTuple.of(instance.red(), instance.green(), instance.blue());
  }
}
