package org.immutables.fixture.serial;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link SomeSer SomeSer} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableSomeSer is not thread-safe</em>
 * @see ImmutableSomeSer
 */
@Generated(from = "SomeSer", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "SomeSer"})
@NotThreadSafe
public final class ModifiableSomeSer extends SomeSer {
  private static final long serialVersionUID = 1L;

  private static final long OPT_BIT_REGULAR = 0x1L;
  private long optBits;

  private int regular;

  private ModifiableSomeSer() {}

  /**
   * Construct a modifiable instance of {@code SomeSer}.
   * @return A new modifiable instance
   */
  public static ModifiableSomeSer create() {
    return new ModifiableSomeSer();
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code regular} attribute
   */
  @Override
  final int regular() {
    if (regularIsSet()) {
      return regular;
    } else {
      return super.regular();
    }
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSomeSer clear() {
    optBits = 0;
    regular = 0;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link SomeSer} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableSomeSer from(SomeSer instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableSomeSer) {
      from((ModifiableSomeSer) instance);
      return this;
    }
    setRegular(instance.regular());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link SomeSer} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableSomeSer from(ModifiableSomeSer instance) {
    Objects.requireNonNull(instance, "instance");
    setRegular(instance.regular());
    return this;
  }

  /**
   * Assigns a value to the {@link SomeSer#regular() regular} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link SomeSer#regular() regular}.</em>
   * @param regular The value for regular
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableSomeSer setRegular(int regular) {
    this.regular = regular;
    optBits |= OPT_BIT_REGULAR;
    return this;
  }

  /**
   * Returns {@code true} if the default attribute {@link SomeSer#regular() regular} is set.
   * @return {@code true} if set
   */
  public final boolean regularIsSet() {
    return (optBits & OPT_BIT_REGULAR) != 0;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableSomeSer unsetRegular() {
    optBits |= 0;
    regular = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableSomeSer ImmutableSomeSer}.
   * @return An immutable instance of SomeSer
   */
  public final ImmutableSomeSer toImmutable() {
    return ImmutableSomeSer.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableSomeSer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableSomeSer)) return false;
    ModifiableSomeSer other = (ModifiableSomeSer) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableSomeSer another) {
    int regular = regular();
    return regular == another.regular();
  }

  /**
   * Computes a hash code from attributes: {@code regular}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    int regular = regular();
    h += (h << 5) + regular;
    return h;
  }

  /**
   * Generates a string representation of this {@code SomeSer}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableSomeSer")
        .add("regular", regular())
        .toString();
  }
}
