package org.immutables.fixture.serial;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SomeSer.OthSer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOthSer.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableOthSer.of()}.
 */
@Generated(from = "SomeSer.OthSer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableOthSer implements SomeSer.OthSer {

  private ImmutableOthSer() {}

  /**
   * This instance is equal to all instances of {@code ImmutableOthSer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOthSer
        && equalTo(0, (ImmutableOthSer) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableOthSer another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -893863200;
  }

  /**
   * Prints the immutable value {@code OthSer}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OthSer{}";
  }

  private static final ImmutableOthSer INSTANCE = validate(new ImmutableOthSer());

  /**
   * Returns the default immutable singleton value of {@code OthSer}
   * @return An immutable instance of OthSer
   */
  public static ImmutableOthSer of() {
    return INSTANCE;
  }

  private static ImmutableOthSer validate(ImmutableOthSer instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link SomeSer.OthSer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OthSer instance
   */
  public static ImmutableOthSer copyOf(SomeSer.OthSer instance) {
    if (instance instanceof ImmutableOthSer) {
      return (ImmutableOthSer) instance;
    }
    return ImmutableOthSer.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link ImmutableOthSer ImmutableOthSer}.
   * <pre>
   * ImmutableOthSer.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableOthSer builder
   */
  public static ImmutableOthSer.Builder builder() {
    return new ImmutableOthSer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOthSer ImmutableOthSer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SomeSer.OthSer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableOthSer} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableOthSer instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code OthSer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SomeSer.OthSer instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableOthSer) {
        return from((ModifiableOthSer) instance);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOthSer ImmutableOthSer}.
     * @return An immutable instance of OthSer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOthSer build() {
      return ImmutableOthSer.of();
    }
  }
}
