package org.immutables.fixture.nullable;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code NonnullConstruction}.
 * @see ImmutableNonnullConstruction
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.nullable", generator = "Gsons")
public final class GsonAdaptersNonnullConstruction implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (NonnullConstructionTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new NonnullConstructionTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersNonnullConstruction(NonnullConstruction)";
  }

  @org.immutables.value.Generated(from = "NonnullConstruction", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class NonnullConstructionTypeAdapter extends TypeAdapter<NonnullConstruction> {

    NonnullConstructionTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return NonnullConstruction.class == type.getRawType()
          || ImmutableNonnullConstruction.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, NonnullConstruction value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeNonnullConstruction(out, value);
      }
    }

    @Override
    public NonnullConstruction read(JsonReader in) throws IOException {
      return readNonnullConstruction(in);
    }

    private void writeNonnullConstruction(JsonWriter out, NonnullConstruction instance)
        throws IOException {
      out.beginObject();
      String[] arrElements = instance.arr();
      out.name("arr");
      out.beginArray();
      for (String e : arrElements) {
        out.value(e);
      }
      out.endArray();
      @Nullable String[] brrElements = instance.brr();
      if (brrElements != null) {
        out.name("brr");
        out.beginArray();
        for (String e : brrElements) {
          out.value(e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("brr");
        out.nullValue();
      }
      List<String> axElements = instance.ax();
      out.name("ax");
      out.beginArray();
      for (String e : axElements) {
        out.value(e);
      }
      out.endArray();
      out.name("a");
      out.value(instance.a());
      out.endObject();
    }

    private  NonnullConstruction readNonnullConstruction(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableNonnullConstruction.Builder builder = ImmutableNonnullConstruction.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableNonnullConstruction.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'a':
        if ("arr".equals(attributeName)) {
          readInArr(in, builder);
          return;
        }
        if ("ax".equals(attributeName)) {
          readInAx(in, builder);
          return;
        }
        break;
      case 'b':
        if ("brr".equals(attributeName)) {
          readInBrr(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInArr(JsonReader in, ImmutableNonnullConstruction.Builder builder)
        throws IOException {
      List<String> elements = new ArrayList<String>();
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          elements.add(in.nextString());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        elements.add(in.nextString());
      }
      builder.arr(elements.toArray(new String[elements.size()]));
    }

    private void readInBrr(JsonReader in, ImmutableNonnullConstruction.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        List<String> elements = new ArrayList<String>();
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            elements.add(in.nextString());
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          elements.add(in.nextString());
        }
        builder.brr(elements.toArray(new String[elements.size()]));
      }
    }

    private void readInAx(JsonReader in, ImmutableNonnullConstruction.Builder builder)
        throws IOException {
      boolean empty = true;
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addAx(in.nextString());
          empty = false;
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addAx(in.nextString());
        empty = false;
      }
      if (empty) {
        builder.addAllAx(Collections.<String>emptyList());
      }
    }
  }
}
