package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NonGrouped.Dabra}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDabra.of()}.
 */
@Generated(from = "NonGrouped.Dabra", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDabra extends NonGrouped.Dabra {
  private final int dabra;

  private ImmutableDabra(int dabra) {
    this.dabra = dabra;
  }

  /**
   * @return The value of the {@code dabra} attribute
   */
  @Override
  int dabra() {
    return dabra;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NonGrouped.Dabra#dabra() dabra} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dabra
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDabra withDabra(int value) {
    if (this.dabra == value) return this;
    return new ImmutableDabra(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDabra} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDabra
        && equalTo(0, (ImmutableDabra) another);
  }

  private boolean equalTo(int synthetic, ImmutableDabra another) {
    return dabra == another.dabra;
  }

  /**
   * Computes a hash code from attributes: {@code dabra}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + dabra;
    return h;
  }

  /**
   * Prints the immutable value {@code Dabra} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Dabra")
        .omitNullValues()
        .add("dabra", dabra)
        .toString();
  }

  /**
   * Construct a new immutable {@code Dabra} instance.
   * @param dabra The value for the {@code dabra} attribute
   * @return An immutable Dabra instance
   */
  public static ImmutableDabra of(int dabra) {
    return new ImmutableDabra(dabra);
  }

  /**
   * Creates an immutable copy of a {@link NonGrouped.Dabra} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Dabra instance
   */
  public static ImmutableDabra copyOf(NonGrouped.Dabra instance) {
    if (instance instanceof ImmutableDabra) {
      return (ImmutableDabra) instance;
    }
    return ImmutableDabra.of(instance.dabra());
  }
}
