package org.immutables.fixture.nested;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code InnerNested}.
 * @see ImmutableInnerNested.Nested
 * @see ImmutableInnerNested
 * @see ImmutableInnerNested.Inner
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.nested", generator = "Gsons")
public final class GsonAdaptersInnerNested implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (NestedTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new NestedTypeAdapter(gson);
    }
    if (InnerNestedTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new InnerNestedTypeAdapter(gson);
    }
    if (InnerTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new InnerTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersInnerNested(Nested, InnerNested, Inner)";
  }

  @org.immutables.value.Generated(from = "InnerNested.Nested", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class NestedTypeAdapter extends TypeAdapter<InnerNested.Nested> {

    NestedTypeAdapter(Gson gson) {}

    static boolean adapts(TypeToken<?> type) {
      return InnerNested.Nested.class == type.getRawType()
          || ImmutableInnerNested.Nested.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, InnerNested.Nested value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeNested(out, value);
      }
    }

    @Override
    public InnerNested.Nested read(JsonReader in) throws IOException {
      return readNested(in);
    }

    private void writeNested(JsonWriter out, InnerNested.Nested instance)
        throws IOException {
      out.beginObject();
      out.endObject();
    }

    private static InnerNested.Nested readNested(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableInnerNested.Nested.Builder builder = ImmutableInnerNested.Nested.builder();
      in.skipValue();
      return builder.build();
    }
  }

  @org.immutables.value.Generated(from = "InnerNested", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class InnerNestedTypeAdapter extends TypeAdapter<InnerNested> {

    InnerNestedTypeAdapter(Gson gson) {}

    static boolean adapts(TypeToken<?> type) {
      return InnerNested.class == type.getRawType()
          || ImmutableInnerNested.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, InnerNested value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeInnerNested(out, value);
      }
    }

    @Override
    public InnerNested read(JsonReader in) throws IOException {
      return readInnerNested(in);
    }

    private void writeInnerNested(JsonWriter out, InnerNested instance)
        throws IOException {
      out.beginObject();
      out.endObject();
    }

    private static InnerNested readInnerNested(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableInnerNested.Builder builder = ImmutableInnerNested.builder();
      in.skipValue();
      return builder.build();
    }
  }

  @org.immutables.value.Generated(from = "InnerNested.Inner", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class InnerTypeAdapter extends TypeAdapter<InnerNested.Inner> {

    InnerTypeAdapter(Gson gson) {}

    static boolean adapts(TypeToken<?> type) {
      return InnerNested.Inner.class == type.getRawType()
          || ImmutableInnerNested.Inner.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, InnerNested.Inner value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeInner(out, value);
      }
    }

    @Override
    public InnerNested.Inner read(JsonReader in) throws IOException {
      return readInner(in);
    }

    private void writeInner(JsonWriter out, InnerNested.Inner instance)
        throws IOException {
      out.beginObject();
      out.endObject();
    }

    private static InnerNested.Inner readInner(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableInnerNested.Inner.Builder builder = ImmutableInnerNested.Inner.builder();
      in.skipValue();
      return builder.build();
    }
  }
}
