package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link NullableListMap NullableListMap} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableNullableListMap is not thread-safe</em>
 * @see ImmutableNullableListMap
 */
@Generated(from = "NullableListMap", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "NullableListMap"})
@NotThreadSafe
public final class ModifiableNullableListMap implements NullableListMap {
  private @Nullable Object object;
  private @Nullable ArrayList<Object> objects = null;
  private @Nullable Map<String, String> map = null;

  private ModifiableNullableListMap() {}

  /**
   * Construct a modifiable instance of {@code NullableListMap}.
   * @return A new modifiable instance
   */
  public static ModifiableNullableListMap create() {
    return new ModifiableNullableListMap();
  }

  /**
   * @return value of {@code object} attribute, may be {@code null}
   */
  @Override
  public final @Nullable Object getObject() {
    return object;
  }

  /**
   * @return modifiable list {@code objects}
   */
  @Override
  public final @Nullable List<Object> getObjects() {
    return objects;
  }

  /**
   * @return value of {@code map} attribute, may be {@code null}
   */
  @Override
  public final @Nullable Map<String, String> getMap() {
    return map;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableListMap clear() {
    object = null;
    objects = null;
    map = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link NullableListMap} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableNullableListMap from(NullableListMap instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableNullableListMap) {
      from((ModifiableNullableListMap) instance);
      return this;
    }
    @Nullable Object objectValue = instance.getObject();
    if (objectValue != null) {
      setObject(objectValue);
    }
    @Nullable List<Object> objectsValue = instance.getObjects();
    if (objectsValue != null) {
      addAllObjects(objectsValue);
    }
    @Nullable Map<String, String> mapValue = instance.getMap();
    if (mapValue != null) {
      putAllMap(mapValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link NullableListMap} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableNullableListMap from(ModifiableNullableListMap instance) {
    Objects.requireNonNull(instance, "instance");
    @Nullable Object objectValue = instance.getObject();
    if (objectValue != null) {
      setObject(objectValue);
    }
    @Nullable List<Object> objectsValue = instance.getObjects();
    if (objectsValue != null) {
      addAllObjects(objectsValue);
    }
    @Nullable Map<String, String> mapValue = instance.getMap();
    if (mapValue != null) {
      putAllMap(mapValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link NullableListMap#getObject() object} attribute.
   * @param object The value for object, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableListMap setObject(@Nullable Object object) {
    this.object = object;
    return this;
  }

  /**
   * Adds one element to {@link NullableListMap#getObjects() objects} list.
   * @param element The objects element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableListMap addObjects(Object element) {
    if (this.objects == null) {
      this.objects = new ArrayList<Object>();
    }
    Objects.requireNonNull(element, "objects element");
    this.objects.add(element);
    return this;
  }

  /**
   * Adds elements to {@link NullableListMap#getObjects() objects} list.
   * @param elements An array of objects elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableListMap addObjects(Object... elements) {
    for (Object e : elements) {
      addObjects(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link NullableListMap#getObjects() objects} list.
   * @param elements An iterable of objects elements, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableListMap setObjects(@Nullable Iterable<? extends Object> elements) {
    if (elements == null) {
      this.objects = null;
      return this;
    }
    if (this.objects == null) {
      this.objects = new ArrayList<Object>();
    } else {
      this.objects.clear();
    }
    addAllObjects(elements);
    return this;
  }

  /**
   * Adds elements to {@link NullableListMap#getObjects() objects} list.
   * @param elements An iterable of objects elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableListMap addAllObjects(Iterable<? extends Object> elements) {
    if (elements == null) return this;
    if (this.objects == null) {
      this.objects = new ArrayList<Object>();
    }
    for (Object e : elements) {
      addObjects(e);
    }
    return this;
  }

  /**
   * Put one entry to the {@link NullableListMap#getMap() map} map.
   * @param key The key in map map
   * @param value The associated value in the map map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableListMap putMap(String key, String value) {
    if (this.map == null) {
      this.map = new LinkedHashMap<String, String>();
    }
    this.map.put(
        Objects.requireNonNull(key, "map key"),
        Objects.requireNonNull(value, "map value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link NullableListMap#getMap() map} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the map map, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableListMap setMap(@Nullable Map<String, ? extends String> entries) {
    if (entries == null) {
      this.map = null;
      return this;
    }
    if (this.map == null) {
      this.map = new LinkedHashMap<String, String>();
    } else {
      this.map.clear();
    }
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.map.put(
          Objects.requireNonNull(k, "map key"),
          Objects.requireNonNull(v, "map value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link NullableListMap#getMap() map} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to map map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableListMap putAllMap(Map<String, ? extends String> entries) {
    if (this.map == null) {
      this.map = new LinkedHashMap<String, String>();
    }
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.map.put(
          Objects.requireNonNull(k, "map key"),
          Objects.requireNonNull(v, "map value"));
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableNullableListMap ImmutableNullableListMap}.
   * @return An immutable instance of NullableListMap
   */
  public final ImmutableNullableListMap toImmutable() {
    return ImmutableNullableListMap.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableNullableListMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableNullableListMap)) return false;
    ModifiableNullableListMap other = (ModifiableNullableListMap) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableNullableListMap another) {
    return Objects.equals(object, another.object)
        && Objects.equals(objects, another.objects)
        && Objects.equals(map, another.map);
  }

  /**
   * Computes a hash code from attributes: {@code object}, {@code objects}, {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(object);
    h += (h << 5) + Objects.hashCode(objects);
    h += (h << 5) + Objects.hashCode(map);
    return h;
  }

  /**
   * Generates a string representation of this {@code NullableListMap}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableNullableListMap")
        .add("object", getObject())
        .add("objects", getObjects())
        .add("map", getMap())
        .toString();
  }
}
